#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WPushButton>
#include <Wt/WCheckBox>

class HelloApp : public Wt::WApplication
{
private:
	Wt::WCheckBox* chkOuter;
	Wt::WCheckBox* chkInner;
	Wt::WPushButton* btn;

public:
	HelloApp(const Wt::WEnvironment& env):
	  Wt::WApplication(env)
	  {
		  chkOuter = new Wt::WCheckBox();
		  chkInner = new Wt::WCheckBox();
		  btn = new Wt::WPushButton();

		  chkOuter->setChecked( true );
		  chkInner->setChecked( true );
		  btn->setText( "Push" );

		  chkOuter->clicked().connect( this, &HelloApp::SetSelected );
		  chkInner->clicked().connect( this, &HelloApp::SetSelected );

		  root()->addWidget( chkOuter );
		  root()->addWidget( chkInner );
		  root()->addWidget( btn );

		  SetSelected();
	  }

	  void SetSelected()
	  {
		  chkInner->setEnabled( chkOuter->isChecked() );
		  btn->setEnabled( chkInner->isChecked() && chkOuter->isChecked() );
	  }
};

Wt::WApplication *createApplication(const Wt::WEnvironment& env)
{
	return new HelloApp(env);
}

int main(int argc, char **argv)
{
	return Wt::WRun(argc, argv, &createApplication);
}
