#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WLogger>

#include <Wt/Dbo/Dbo>
#include <Wt/Dbo/backend/Firebird>
#include <Wt/Dbo/QueryModel>
#include <Wt/WTableView>
#include <Wt/WSlider>
#include <Wt/WHBoxLayout>
#include <Wt/WContainerWidget>
#include <Wt/WText>
#include <Wt/WLineEdit>
#include <Wt/WCssDecorationStyle>
#include <Wt/WCheckBox>
#include <Wt/WPushButton>

#include <boost/filesystem.hpp>
#include <boost/filesystem/operations.hpp>

#include "mir_trkeys.h"
#include "mir_defines.h"
#include "mir_sp_prezentacja.h"

namespace SyNaT
{
  namespace MIR 
  {
    namespace SP
    {

      using namespace std;
      using namespace Wt;
      using namespace boost::filesystem;

      namespace dbo = Wt::Dbo;

      class NazArtNazAlbItp
      {
        public:
          long long m_naa_id;
          string m_nazwa_artysty;
          string m_nazwa_albumu;
          string m_gatunek;
          string m_tytul_utworu;
          string m_utid;
          string m_umid;
          template<class Action> void persist(Action& a)
          {
            dbo::field(a, m_naa_id, "NAA_ID");
            dbo::field(a, m_nazwa_artysty,     "ART_NAZWA_ARTYSTY");
            dbo::field(a, m_nazwa_albumu, "ALB_NAZWA_ALBUMU");
            dbo::field(a, m_gatunek, "GAT_GATUNEK");
            dbo::field(a, m_tytul_utworu, "UTW_TYTUL_UTWORU");
            dbo::field(a, m_utid, "UTID");
            dbo::field(a, m_umid, "UMID");
          }
      };

      class NazArtNazAlbItpModel : public dbo::QueryModel<dbo::ptr<NazArtNazAlbItp> >
      {
      public:

        NazArtNazAlbItpModel(WObject *parent = 0)
          : dbo::QueryModel<dbo::ptr<NazArtNazAlbItp> >(parent)
        {
        }

        virtual ~NazArtNazAlbItpModel()
        {
        }

        virtual boost::any data(const WModelIndex& index, int role = DisplayRole)
          const
        {
          switch (role)
          {
          case DisplayRole:
          case EditRole:
            {
              if (index.column() == 0)
                return WString::fromUTF8(boost::lexical_cast<string>(index.row() + 1));
              else return this->dbo::QueryModel<dbo::ptr<NazArtNazAlbItp> >::data(index, role);
              break;
            }
          }
          return boost::any(); 

        }
          protected:
            string                m_temp_sel_sql;
            string                m_temp_del_sql;

            IBPP::Transaction     m_tr;
            IBPP::Statement       m_stmt;
        };  


      Prezentacja::Prezentacja(const WEnvironment& env)
        : WApplication(env), m_firebird(/*connection parameters*/)
      {
#ifdef WIN32
        string path_to_rb = Prezentacja::mcs_root_elem + MIR_FULLPATH_TO_MESS_RES_BUNDLE;
#else
        string path_to_rb = MIR_FULLPATH_TO_MESS_RES_BUNDLE;
#endif
        this->messageResourceBundle().use(path_to_rb);

        this->setCssTheme("polished");

        this->useStyleSheet("css/reset.css");
        //this->useStyleSheet("/css/wt/wt.css");
        //this->useStyleSheet("/css/wt/wt_ie.css", "lt IE 7");
        this->useStyleSheet("style/everywidget.css");
        this->useStyleSheet("style/dragdrop.css");
        this->useStyleSheet("style/combostyle.css");

        this->setTitle(WString::tr(MIR_SYNAT_BROWSER_TITLE));

        WContainerWidget *wcw = new WContainerWidget(this->root());
        wcw->setClearSides(Left | Right);
        
        m_session.setConnection(m_firebird);

        m_session.mapClass<NazArtNazAlbItp>("MIR_NAZARTNAZALBITP"); 

        this->m_rows = 20;

        m_wtv = new WTableView();

        NazArtNazAlbItpModel *qmodel = new NazArtNazAlbItpModel(this);
        {
          dbo::Transaction transaction(m_session);
          dbo::Query< dbo::ptr<NazArtNazAlbItp> > query =
              m_session.query< dbo::ptr<NazArtNazAlbItp> >
                ("select u  from MIR_NAZARTNAZALBITP u ");

          qmodel->setQuery(query, true);
          transaction.commit();
        }
        qmodel->addColumn("NAA_ID", "No");
        qmodel->addColumn("ART_NAZWA_ARTYSTY", "Artist");
        qmodel->addColumn("ALB_NAZWA_ALBUMU", "Album");
        qmodel->addColumn("GAT_GATUNEK", "Genre");
        qmodel->addColumn("UTW_TYTUL_UTWORU", "Title");
        qmodel->setBatchSize(m_rows * 100);
        m_wtv->setModel(qmodel);
        m_wtv->setSortingEnabled(0, false);
        m_wtv->setSortingEnabled(1, true);
        m_wtv->setSortingEnabled(2, true);
        m_wtv->setSortingEnabled(3, true);
        m_wtv->setSortingEnabled(4, true);
        m_wtv->setRowHeight(22);
        int cols = 5, colWidth = 100;
        m_wtv->setColumnWidth(0, 50);
        for (int i = 1; i < cols; i++)
        {
          m_wtv->setColumnWidth(i, colWidth);
        }
        m_wtv->resize((cols - 1) * colWidth + (cols - 1) * 7 + 50 + 2 * 7 + 20, 20 + m_rows * 22);
        m_wtv->setAlternatingRowColors(true);
        m_wtv->setSelectable(true); 

        WHBoxLayout *layout = new WHBoxLayout();
        layout->addWidget(m_wtv);
        m_slider = new WSlider(Vertical);
        m_slider->setTickPosition(WSlider::TicksRight);
        m_slider->resize(50, m_rows * 22);
        this->m_page_count = m_wtv->model()->rowCount() / m_rows; 
        int reminder = m_wtv->model()->rowCount() % m_rows;
        int max = m_page_count + (reminder > 0 ? 0 : -1);
        int tickInterval = (int) this->m_slider->height().value() / max;

        if (tickInterval < 10)
          tickInterval = (int) (10 * max) / this->m_slider->height().value();
        this->m_slider->setTickInterval(tickInterval); 

        m_slider->setRange(0, max);
        m_slider->setValue(max);
        m_slider->valueChanged().connect(this, &Prezentacja::slt_sliderValueChanged);
        layout->addWidget(m_slider);
        wcw->setLayout(layout, AlignTop | AlignJustify);
      }

      void Prezentacja::slt_sliderValueChanged(int page)
      {
        int page_scroll_to = this->m_slider->maximum() - page;
        this->m_wtv->scrollTo(this->m_wtv->model()
                        ->index(page_scroll_to * this->m_rows, 0), WTableView::PositionAtTop); 
      }

      Prezentacja::~Prezentacja()
      {
      }

      const string Prezentacja::mcs_root_elem = (*current_path().begin()).string();
    } // namespace SP
  } // namespace MIR
} // namespace SyNaT


namespace Wt
{
  namespace Dbo
  {

    template<>
    struct dbo_traits<SyNaT::MIR::SP::NazArtNazAlbItp> : public dbo_default_traits
    {

      static const char *versionField()
      {
        return 0;
      }

      static const char *surrogateIdField()
      {
        return "UTW_ID";
      }

    };

  }
}  