#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WLogger>

#include <Wt/WTableView>
#include <Wt/WSlider>
#include <Wt/WHBoxLayout>
#include <Wt/WContainerWidget>
#include <Wt/WText>
#include <Wt/WLineEdit>
#include <Wt/WCssDecorationStyle>
#include <Wt/WCheckBox>
#include <Wt/WPushButton>
#include <Wt/WStandardItemModel>
#include <Wt/WStandardItem>

#include "mir_sp_prezentacja.h"

namespace SyNaT
{
  namespace MIR 
  {
    namespace SP
    {

      using namespace std;
      using namespace Wt;

      Prezentacja::Prezentacja(const WEnvironment& env)
        : WApplication(env)
      {
        this->setCssTheme("polished");

        this->setTitle("title");

        WContainerWidget *wcw = new WContainerWidget(this->root());
        wcw->setClearSides(Left | Right);
        
        this->m_rows = 20;

        m_wtv = new WTableView();

         int rows = 1000;
         int columns = 5;

         Wt::WStandardItemModel *model = new Wt::WStandardItemModel(rows, columns, this);

         for (int row = 0; row < rows; ++row) {
          for (int column = 0; column < columns; ++column) {
            Wt::WStandardItem *item = new Wt::WStandardItem();
            item->setText("Item " + boost::lexical_cast<std::string>(row)
            + ", " + boost::lexical_cast<std::string>(column));
            model->setItem(row, column, item);
          }
         }

         model->setHeaderData (0, WString("No"));
         model->setHeaderData (1, WString("Artist"));
         model->setHeaderData (2, WString("Album"));
         model->setHeaderData (3, WString("Genre"));
         model->setHeaderData (4, WString("Title"));

        m_wtv->setModel(model);
        m_wtv->setSortingEnabled(0, false);
        m_wtv->setSortingEnabled(1, true);
        m_wtv->setSortingEnabled(2, true);
        m_wtv->setSortingEnabled(3, true);
        m_wtv->setSortingEnabled(4, true);
        m_wtv->setRowHeight(22);
        int cols = 5, colWidth = 100;
        m_wtv->setColumnWidth(0, 50);
        for (int i = 1; i < cols; i++)
        {
          m_wtv->setColumnWidth(i, colWidth);
        }
        m_wtv->resize((cols - 1) * colWidth + (cols - 1) * 7 + 50 + 2 * 7 + 20, 20 + m_rows * 22);
        m_wtv->setAlternatingRowColors(true);
        m_wtv->setSelectable(true); 

        WHBoxLayout *layout = new WHBoxLayout();
        layout->addWidget(m_wtv);
        m_slider = new WSlider(Vertical);
        m_slider->setTickPosition(WSlider::TicksRight);
        m_slider->resize(50, m_rows * 22);
        this->m_page_count = m_wtv->model()->rowCount() / m_rows; 
        int reminder = m_wtv->model()->rowCount() % m_rows;
        int max = m_page_count + (reminder > 0 ? 0 : -1);
        int tickInterval = (int) this->m_slider->height().value() / max;

        if (tickInterval < 10)
          tickInterval = (int) (10 * max) / this->m_slider->height().value();
        this->m_slider->setTickInterval(tickInterval); 

        m_slider->setRange(0, max);
        m_slider->setValue(max);
        m_slider->valueChanged().connect(this, &Prezentacja::slt_sliderValueChanged);
        layout->addWidget(m_slider);
        wcw->setLayout(layout, AlignTop | AlignJustify);
      }

      void Prezentacja::slt_sliderValueChanged(int page)
      {
        int page_scroll_to = this->m_slider->maximum() - page;
        this->m_wtv->scrollTo(this->m_wtv->model()
                        ->index(page_scroll_to * this->m_rows, 0), WTableView::PositionAtTop); 
      }

      Prezentacja::~Prezentacja()
      {
      }

    } // namespace SP
  } // namespace MIR
} // namespace SyNaT

