﻿#ifndef _MIR_MR_SP_PREZENTACJA_H_
#define _MIR_MR_SP_PREZENTACJA_H_
/*
 * Copyright (c) 2011,
 * Technical University Of Gdansk,
 * Faculty of Electronics, Telecommunications and Informatics,
 * Multimedia Systems Department
 * and/or its affiliates. All rights reserved.
 */

#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WTableView>
#include <Wt/WSlider>
#include <string>
#include <Wt/Dbo/Dbo>
#include <Wt/Dbo/QueryModel>
#include <Wt/WWidget>
#include <Wt/WEvent>
#include <Wt/Dbo/backend/Firebird>
#include "mir_wcustomtableview.h"

using namespace std;
using namespace Wt;
namespace dbo = Wt::Dbo;

class NazArtNazAlbItp
{
public:
  long long m_naa_id;
  string m_nazwa_artysty;
  string m_nazwa_albumu;
  string m_gatunek;
  string m_tytul_utworu;
  short  m_rok_nagrania;
  short  m_nr_sciezki;
  template<class Action> void persist(Action& a)
  {
    dbo::field(a, m_naa_id, "NAA_ID");
    dbo::field(a, m_nazwa_artysty,     "ART_NAZWA_ARTYSTY");
    dbo::field(a, m_nazwa_albumu, "ALB_NAZWA_ALBUMU");
    dbo::field(a, m_gatunek, "GAT_GATUNEK");
    dbo::field(a, m_tytul_utworu, "UTW_TYTUL_UTWORU");
    dbo::field(a, m_rok_nagrania, "UTW_ROK_NAGRANIA");
    dbo::field(a, m_nr_sciezki, "UTW_NR_SCIEZKI");
  }
};

namespace Wt
{
  namespace Dbo
  {

    template<>
    struct dbo_traits<NazArtNazAlbItp> : public dbo_default_traits
    {

      static const char *versionField()
      {
        return 0;
      }

      static const char *surrogateIdField()
      {
        return "UTW_ID";
      }

    };

  }
}


namespace SyNaT
{
  namespace MIR
  {
    namespace SP
    {





      /**
       * A <code>Prezentacja</code> is main application class which is instantiated
       * per user session.
       *
       * @author  Łukasz Matuszewski
       * @version $Id$
       */
      class Prezentacja : public WApplication
      {
        protected:
        public:
          Wt::Dbo::backend::Firebird                    m_firebird;
          dbo::Transaction                             *m_transaction;

          dbo::Session                                  m_session;

          int                                           m_rows;

          int                                           m_page_count;

          WCustomTableView<Wt::Dbo::ptr<NazArtNazAlbItp> >            *m_wtv;

          WSlider                                      *m_slider;

                                                        Prezentacja(const WEnvironment& env);

	  void 						changeLanguage();

          virtual                                      ~Prezentacja();

          const static string                           mcs_root_elem;

	  }; // class SyNaTPGApp

    } // namespace SP
  } // namespace MIR
} // namespace SyNaT


class SearchModel : public dbo::QueryModel<dbo::ptr<NazArtNazAlbItp> >
{
  public:

  SearchModel(SyNaT::MIR::SP::Prezentacja *sec)
    : dbo::QueryModel<dbo::ptr<NazArtNazAlbItp> >(sec)
    {
    }

    virtual ~SearchModel()
    {
    }

};

#endif //_MIR_MR_SP_PREZENTACJA_H_
