#ifndef _MIR_WCUSTOMTABLEVIEW_H_
#define _MIR_WCUSTOMTABLEVIEW_H_
/*
 * Copyright (c) 2011,
 * Technical University Of Gdansk,
 * Faculty of Electronics, Telecommunications and Informatics,
 * Multimedia Systems Department
 * and/or its affiliates. All rights reserved.
 */
#include <Wt/WEnvironment>
#include <Wt/WContainerWidget>
#include <Wt/WCompositeWidget>
#include <Wt/WAbstractItemModel>
#include <Wt/WTableView>
#include <Wt/WAnchor>
#include <Wt/WPushButton>
#include <Wt/WCheckBox>
#include <Wt/WLineEdit>
#include <Wt/WComboBox>
#include <Wt/WLink>
#include <Wt/WText>
#include <Wt/Dbo/Dbo>
#include <Wt/Dbo/QueryModel>
#include <Wt/WEvent>
#include <Wt/WHBoxLayout>
#include <Wt/WSlider>
#include <Wt/WEvent>

#include <boost/foreach.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/any.hpp>
#include <boost/bind.hpp>

#include <vector>

#include "mir_defines.h"
#include "mir_trkeys.h"
#include "mir_cssclasses.h"
#include "mir_internalpaths.h"
#include "mir_wcustomtableviewpushbutton.h"

namespace SyNaT
{
  namespace MIR
  {
    using namespace Wt;
    using namespace std;
    namespace dbo = Wt::Dbo;

    template <class Result>
    class WCustomTableView;

    enum WCustomTableViewEnum
    {
      ShowExportAll = 1,
      ShowSelectionBar = 2,
      ShowSearchBar = 4,
      ShowSelectedDisplayed = 8,
      ShowStrictFiltering = 16,
      ShowAdvancedSearchAnchor = 32
    };


    template <class Result>
    class WCustomTableViewImpl : public WContainerWidget
    {
      friend class WCustomTableViewPushButton<Result>;

      public:

        WCustomTableViewImpl(WCustomTableView<Result> *ctv = 0
                           , int whatToShow = (ShowExportAll|ShowSelectionBar|ShowSearchBar|ShowSelectedDisplayed|ShowStrictFiltering|ShowAdvancedSearchAnchor))
          : m_customTableView(ctv), m_checkable(false)
          , m_current_page(0), m_nav_bar_created(false), m_num_of_pages_in_nav_bar(1)
          , m_first_page_in_nav_bar(0), m_last_page_in_nav_bar(m_num_of_pages_in_nav_bar-1)
          , m_pref_num_of_pages_in_nav_bar(4), m_whatToShow(whatToShow)
          , m_row_count(0)
        {
          WContainerWidget *options_bar = new WContainerWidget();
          this->addWidget(options_bar);

          if (this->m_whatToShow & ShowSearchBar)
          {
            options_bar->setClearSides(Left | Right);
            //this->m_txt = new WText(tr(MIR_TABLE_EXP_SEARCH).arg(WString::Empty), options_bar);
            //this->m_txt->disable();
            this->m_sle = new WLineEdit(options_bar);
            this->m_sle->setTextSize(30);

            this->m_scb = new WComboBox(options_bar);
            this->m_scb->addStyleClass(MIR_STRINGIFY(MIR_CSS_MARGIN_RIGHT_30PX));
            //this->m_sle->disable();
            //if (likeStatement)
            //{
            //  this->m_wcb = new WCheckBox(tr(MIR_TABLE_EXP_LIKE), options_bar);
            //  this->m_wcb->disable();
            //}

            this->m_wpb = new WPushButton(tr(MIR_WCTV_APPLY_SEARCH), options_bar);
            this->m_wpb->addStyleClass(MIR_STRINGIFY(MIR_CSS_MARGIN_RIGHT_30PX));
            this->m_show_only_selected = new WCheckBox(tr(MIR_WCTV_SHOW_ONLY_SELECTED), options_bar);
            this->m_show_only_selected->setStyleClass(MIR_STRINGIFY(MIR_CSS_FONT_SIZE_SMALL));
            if (this->m_whatToShow & ShowStrictFiltering)
            {
              this->m_strict_filtering = new WCheckBox(tr(MIR_WCTV_STRICT_FILTERING), options_bar);
              this->m_strict_filtering->setStyleClass(MIR_STRINGIFY(MIR_CSS_FONT_SIZE_SMALL));
              this->m_strict_filtering->addStyleClass(MIR_STRINGIFY(MIR_CSS_MARGIN_RIGHT_30PX));
            }

          }
          if (this->m_whatToShow & ShowAdvancedSearchAnchor)
          {
            options_bar->setClearSides(Left | Right);
            this->m_wpb_adv_search = new WPushButton(tr(MIR_WCTV_ADVANCED_SEARCH), options_bar);
            this->m_wpb_adv_search->setStyleClass(MIR_STRINGIFY(MIR_CSS_PAGE_NAV_BUTTON));
          }
          
          if (this->m_whatToShow & ShowSelectedDisplayed)
          {
            this->m_selected_displayed = new WContainerWidget();
            this->addWidget(this->m_selected_displayed);
            this->m_selected_displayed->setClearSides(Left | Right);

            this->m_txt_selected = new WText(tr(MIR_WCTV_SELECTED), this->m_selected_displayed);
            this->m_txt_selected->setStyleClass(MIR_STRINGIFY(MIR_CSS_FONT_SIZE_SMALL));

            this->m_txt_all_displayed = new WText(tr(MIR_WCTV_ALL_DISPLAYED), this->m_selected_displayed);
            this->m_txt_all_displayed->setStyleClass(MIR_STRINGIFY(MIR_CSS_FONT_SIZE_SMALL));
          }

          WHBoxLayout *layout = NULL;

          if (this->m_whatToShow & ShowSelectionBar)
          {
            this->m_select_inverse_unselect = new WContainerWidget();
            this->addWidget(this->m_select_inverse_unselect);
            this->m_select_inverse_unselect->setClearSides(Left | Right);

            layout = new WHBoxLayout();
            this->m_selectAll = new WPushButton(tr(MIR_WCTV_SELECT_ALL_FILTERED));
            layout->addWidget(this->m_selectAll);
            this->m_selectAll->setStyleClass(MIR_STRINGIFY(MIR_CSS_PAGE_NAV_BUTTON));
            this->m_inverseSelection = new WPushButton(tr(MIR_WCTV_INVERSE_SELECTION));
            layout->addWidget(this->m_inverseSelection);
            this->m_inverseSelection->setStyleClass(MIR_STRINGIFY(MIR_CSS_PAGE_NAV_BUTTON));
  //          new WText("&nbsp;&nbsp;&nbsp;", XHTMLText, options_bar);
            this->m_unselectAll = new WPushButton(tr(MIR_WCTV_UNSELECT_ALL_FILTERED));
            layout->addWidget(this->m_unselectAll);
            this->m_unselectAll->setStyleClass(MIR_STRINGIFY(MIR_CSS_PAGE_NAV_BUTTON));

            this->m_wpb_refresh = new WPushButton(tr(MIR_WCTV_REFRESH));
            this->m_wpb_refresh->setStyleClass(MIR_STRINGIFY(MIR_CSS_PAGE_NAV_BUTTON));
            layout->addWidget(this->m_wpb_refresh);

            this->m_select_inverse_unselect->setLayout(layout, AlignTop | AlignJustify);
          }
          else
          {
            this->m_select_inverse_unselect = new WContainerWidget();
            this->addWidget(this->m_select_inverse_unselect);
            this->m_select_inverse_unselect->setClearSides(Left | Right);

            layout = new WHBoxLayout();

            this->m_wpb_refresh = new WPushButton(tr(MIR_WCTV_REFRESH));
            this->m_wpb_refresh->setStyleClass(MIR_STRINGIFY(MIR_CSS_PAGE_NAV_BUTTON));
            layout->addWidget(this->m_wpb_refresh);

            this->m_select_inverse_unselect->setLayout(layout, AlignTop | AlignRight);
          }

          options_bar = new WContainerWidget();
          options_bar->setClearSides(Left | Right);
          layout = new WHBoxLayout();
          this->m_wtv = new WTableView();
          layout->addWidget(this->m_wtv);
          this->m_slider = new WSlider(Vertical);
          this->m_slider->setTickPosition(WSlider::TicksRight);
          layout->addWidget(this->m_slider);
          options_bar->setLayout(layout, AlignTop | AlignJustify);
          this->addWidget(options_bar);

          if (this->m_whatToShow & ShowExportAll)
          {
            this->m_export_all = new WContainerWidget();
            this->addWidget(this->m_export_all);
            this->m_export_all->setClearSides(Left | Right);
  //          WPushButton *wpb = new WPushButton(tr(MIR_WCTV_SAVE_SEL), options_bar);
  //          wpb->setStyleClass(MIR_STRINGIFY(MIR_CSS_PAGE_NAV_BUTTON));
  //          new WText("&nbsp;&nbsp;&nbsp;", XHTMLText, options_bar);

            WAnchor *ar = new WAnchor(WLink(WLink::InternalPath, "/someInternalPath"), tr(MIR_WCTV_EXPORT_SEL_PARS), this->m_export_all);
            ar->setStyleClass(MIR_STRCAT3(MIR_CSS_FONT_SIZE_SMALL, " ", MIR_CSS_COLOR_BLUE));
            ar->setTarget(TargetNewWindow);
          }

          this->m_page_nav_bar = new WContainerWidget();
          this->addWidget(this->m_page_nav_bar);
          this->m_page_nav_bar->setClearSides(Left | Right);

          this->m_no_results = new WContainerWidget();
          
          this->m_no_results->setMargin(WLength::Auto, Left | Right);

          this->m_no_results->setWidth(WLength(100, WLength::Percentage));
          this->addWidget(this->m_no_results);
          this->m_no_results->setClearSides(Left | Right);
        }

        virtual ~WCustomTableViewImpl()
        {
        }

        WText &selectedText()
        {
          return *(this->m_txt_selected);
        }

        WText &displayedAllText()
        {
          return *(this->m_txt_all_displayed);
        }

        WLineEdit &searchLineEdit()
        {
          return *(this->m_sle);
        }

        WComboBox &searchComboBox()
        {
          return *(this->m_scb);
        }

        WPushButton &searchPushButton()
        {
          return *(this->m_wpb);
        }

        WCheckBox &showOnlySelectedCheckBox()
        {
          return *(this->m_show_only_selected);
        }

        WCheckBox &strictFiltering()
        {
          return *(this->m_strict_filtering);
        }

        //WCheckBox &searchCheckBoxLike()
        //{
        //  return *(this->m_wcb);
        //}

        WPushButton &selectAllPushButton()
        {
          return *(this->m_selectAll);
        }

        WPushButton &inverseSelection()
        {
          return *(this->m_inverseSelection);
        }

        WPushButton &unselectAllPushButton()
        {
          return *(this->m_unselectAll);
        }

        WSlider &slider()
        {
          return *(this->m_slider);
        }

        WPushButton &refresh_button()
        {
          return *(this->m_wpb_refresh);
        }

        WPushButton &adv_search_button()
        {
          return *(this->m_wpb_adv_search);
        }

        int update_slider()
        {
          int max = MAX_SLIDER_VALUE;
          this->m_slider->setRange(0, max);
          int tickInterval = (int) (max / 50);

          this->m_slider->setTickInterval(tickInterval);
          return max;
        }

        virtual void load()
        {
          if (!this->loaded())
          {
            this->m_first_page_in_nav_bar = 0;
            this->m_page_nav_bar->setLayout(this->create_page_nav_bar(), AlignTop | AlignJustify);
            this->m_slider->setValue(this->update_slider());

            this->m_slider->sliderMoved().connect(this, &WCustomTableViewImpl::slt_sliderMoved);

            this->m_nav_bar_created = true;
          }
          this->WContainerWidget::load();

          this->setupVisibilityOfWidgets(this->m_row_count);
        }

        int rowsPerPage() const
        {
          return this->m_rows_per_page;
        }

        void setRowsPerPage(const int rows)
        {
          this->m_rows_per_page = rows;
        }

        void slt_sliderMoved(int page_clicked)
        {
          bool nbnu = false;
//          if (this->pageCount() >= page_clicked)
//          {
            page_clicked = (int) (((this->m_slider->maximum() - page_clicked) / (this->m_slider->maximum() * 1.0)) * (this->pageCount() - 1));

            if (this->m_current_page != page_clicked)
            {
              if (page_clicked <= this->pageCount())
                this->scrollTo(
                      this->model()
                        ->index(page_clicked * this->rowsPerPage(), 0), WTableView::PositionAtTop);
              this->m_first_page_in_nav_bar = page_clicked;
              this->m_last_page_in_nav_bar = page_clicked + this->m_num_of_pages_in_nav_bar - 1;
              if ((this->m_first_page_in_nav_bar + this->m_num_of_pages_in_nav_bar) > this->pageCount())
              {
                this->m_first_page_in_nav_bar = this->pageCount() - this->m_num_of_pages_in_nav_bar;
                this->m_last_page_in_nav_bar = this->pageCount();
              }
              this->m_current_page = page_clicked;

              nbnu = true;
            }
//          }
//          else
//          {
//            this->update_slider();
//            this->m_slider->setValue(this->m_slider->maximum());
//          }
          this->update_page_nav_bar(nbnu);
        }

        dbo::QueryModel<Result> *model() const
        {
          return dynamic_cast<dbo::QueryModel<Result> *>(this->m_wtv->model());
        }

        void setModel(dbo::QueryModel<Result> *model)
        {

          if (model)
            model->layoutChanged().connect(this, &WCustomTableViewImpl::slt_modelLayoutChanged);
          this->m_wtv->setModel(model);
          this->m_row_count = this->model()->rowCount();
          this->m_page_count_reminder = (this->m_row_count > this->rowsPerPage()) ? this->m_row_count % this->rowsPerPage() : 0;
          this->m_page_count = (int) (((this->m_row_count * 1.0)/ (this->rowsPerPage()) + ((this->m_page_count_reminder) > 0 ? 1 : 0)));

          this->setupVisibilityOfWidgets(this->m_row_count);
        }

        void slt_modelLayoutChanged()
        {
          //int sortColumn = this->sortColumn();
          //if (sortColumn > -1)
          //{
            //WString headerName = boost::any_cast<WString>(this->model()->headerData(sortColumn));
            //this->m_txt->setText(tr(MIR_TABLE_EXP_SEARCH).arg(headerName));
            //this->m_txt->enable();
            //this->m_sle->enable();
            //this->m_wcb->enable();
          //}
          //else
          //{
            //this->m_txt->setText(tr(MIR_TABLE_EXP_SEARCH).arg(WString::Empty));
            //this->m_txt->disable();
            //this->m_sle->disable();
            //this->m_wcb->disable();
          //}
          this->m_row_count = this->model()->rowCount();
          this->m_page_count_reminder = (this->m_row_count > this->rowsPerPage()) ? this->m_row_count % this->rowsPerPage() : 0;
          this->m_page_count = (int) (((this->m_row_count * 1.0)/ (this->rowsPerPage()) + ((this->m_page_count_reminder) > 0 ? 1 : 0)));

          this->setupVisibilityOfWidgets(this->m_row_count);

        }

		void setupVisibilityOfWidgets(int row_count)
		{
      this->m_no_results->clear();


      if (row_count > this->rowsPerPage())
      {
        this->slider().show();
    		//this->slider().removeStyleClass(MIR_STRINGIFY(MIR_CSS_DISPLAY_NONE_IMPORTANT), true);
      }
      else
      {
        this->slider().hide();
       // if (this->slider().styleClass().toUTF8().find(MIR_STRINGIFY(MIR_CSS_DISPLAY_NONE_IMPORTANT)) == string::npos)
			    //this->slider().addStyleClass(MIR_STRINGIFY(MIR_CSS_DISPLAY_NONE_IMPORTANT));
      }

      //string jQuerySel = "$('#" + this->slider().id() + "')";
      //if (row_count > this->rowsPerPage())
      //{
      //  WApplication::instance()->doJavaScript(jQuerySel + ".removeClass('" MIR_STRINGIFY(MIR_CSS_DISPLAY_NONE_IMPORTANT) "');");
      //}
      //else
      //{
      //  WApplication::instance()->doJavaScript("if (!" + jQuerySel + ".hasClass('" MIR_STRINGIFY(MIR_CSS_DISPLAY_NONE_IMPORTANT) "')) " + jQuerySel + ".addClass('" MIR_STRINGIFY(MIR_CSS_DISPLAY_NONE_IMPORTANT) "');");
      //}


      if (row_count == 0)
      {
        WText *txt_no_results = new WText(tr(MIR_WCTV_NO_RESULTS), this->m_no_results);
        txt_no_results->setStyleClass(MIR_STRINGIFY(MIR_CSS_COLOR_RED));
        this->m_wtv->addStyleClass(MIR_STRINGIFY(MIR_CSS_DISPLAY_NONE_IMPORTANT), true);

        if (this->m_whatToShow & ShowSelectedDisplayed)
        {
          this->m_selected_displayed->addStyleClass(MIR_STRINGIFY(MIR_CSS_DISPLAY_NONE_IMPORTANT), true);
        }
        if (this->m_whatToShow & ShowSelectionBar)
        {
          this->m_select_inverse_unselect->addStyleClass(MIR_STRINGIFY(MIR_CSS_DISPLAY_NONE_IMPORTANT), true);
        }
        if (this->m_whatToShow & ShowExportAll)
        {
          this->m_export_all->addStyleClass(MIR_STRINGIFY(MIR_CSS_DISPLAY_NONE_IMPORTANT), true);
        }
      	this->m_page_nav_bar->addStyleClass(MIR_STRINGIFY(MIR_CSS_DISPLAY_NONE_IMPORTANT), true);
      }
      else
      {
        this->m_wtv->removeStyleClass(MIR_STRINGIFY(MIR_CSS_DISPLAY_NONE_IMPORTANT), true);
        if (this->m_whatToShow & ShowSelectedDisplayed)
        {
          this->m_selected_displayed->removeStyleClass(MIR_STRINGIFY(MIR_CSS_DISPLAY_NONE_IMPORTANT), true);
        }
        if (this->m_whatToShow & ShowSelectionBar)
        {
          this->m_select_inverse_unselect->removeStyleClass(MIR_STRINGIFY(MIR_CSS_DISPLAY_NONE_IMPORTANT), true);
        }
        if (this->m_whatToShow & ShowExportAll)
        {
          this->m_export_all->removeStyleClass(MIR_STRINGIFY(MIR_CSS_DISPLAY_NONE_IMPORTANT), true);
        }
			  this->m_page_nav_bar->removeStyleClass(MIR_STRINGIFY(MIR_CSS_DISPLAY_NONE_IMPORTANT), true);
      }
		}

        void setSortingEnabled(int column, bool enabled)
        {
          this->m_wtv->setSortingEnabled(column, enabled);
        }

        void setSortingEnabled(bool enabled)
        {
          this->m_wtv->setSortingEnabled(enabled);
        }

        virtual void setRowHeight(const WLength& rowHeight)
        {
          this->m_wtv->setRowHeight(rowHeight);
        }

        virtual void setColumnWidth(int column, const WLength& width)
        {
          this->m_wtv->setColumnWidth(column, width);
        }

        void sortByColumn(int column, SortOrder order)
        {
          this->m_wtv->sortByColumn(column, order);
        }

        virtual void setAlternatingRowColors(bool enable)
        {
          this->m_wtv->setAlternatingRowColors(enable);
        }

        void setItemDelegateForColumn(int column, WAbstractItemDelegate *delegate)
        {
          this->m_wtv->setItemDelegateForColumn(column, delegate);
        }

        virtual void setSelectable(bool selectable)
        {
          this->m_wtv->setSelectable(selectable);
        }

        virtual void setCheckable(const bool checkable)
        {
          this->m_checkable = checkable;
        }

        virtual void resize(const int& widthPx, const int& heightPx)
        {
          //this->WContainerWidget::resize(widthPx, heightPx);
          this->m_wtv->resize(widthPx, heightPx-120);
          this->m_slider->setHeight(heightPx-120);
        }

        virtual void resize(const WLength& width, const WLength& height)
        {
          //this->WContainerWidget::resize(width, height);
        }

        virtual void resize_inner_table_view(const WLength& width, const WLength& height)
        {
          this->m_wtv->resize(width, height);
        }

        virtual void scrollTo(const WModelIndex& index,
            Wt::WTableView::ScrollHint hint = Wt::WTableView::EnsureVisible)
        {
          this->m_wtv->scrollTo(index, hint);
        }

        virtual int pageCount() const
        {
          return this->m_page_count;//(this->model()->rowCount() / (this->rowsPerPage()));
        }

		int rowCount() const
		{
		  return this->m_row_count;
		}

        virtual int pageCountReminder() const
        {
          return this->m_page_count_reminder;//(this->model()->rowCount() / (this->rowsPerPage()));
        }



        virtual int pageSize() const
        {
          return this->m_wtv->pageSize();
        }

        virtual void setPrefNumOfPagesInNavBar(int num_of_pages)
        {
          this->m_pref_num_of_pages_in_nav_bar = num_of_pages;
        }

        virtual int sortColumn()
        {
          return this->m_wtv->sortColumn();
        }

        virtual void refresh()
        {
          this->m_wtv->refresh();
        }

        void update_page_nav_bar(const bool navBarNeedUpdate = false)
        {
          int page_count = this->pageCount();
          if (navBarNeedUpdate && this->m_nav_bar_created)
          {
            //if (page_count < this->m_first_page_in_nav_bar + this->m_pref_num_of_pages_in_nav_bar - 1)
            if (page_count < this->m_first_page_in_nav_bar + this->m_num_of_pages_in_nav_bar - 1)
            {
              this->m_first_page_in_nav_bar = 0;
              this->m_num_of_pages_in_nav_bar = page_count - this->m_first_page_in_nav_bar;
              this->m_current_page = 0;
//              this->model()->reload();
              this->m_wtv
                ->scrollTo(
                    this->model()->index(0, 0), WTableView::PositionAtTop);
            }
            else
              this->m_num_of_pages_in_nav_bar = this->m_pref_num_of_pages_in_nav_bar;

            this->m_page_nav_bar->clear();
            this->m_page_numbers.clear();
            this->m_page_nav_bar->setLayout(this->create_page_nav_bar(), AlignTop | AlignJustify);
          }
          if ((this->m_page_numbers.size() > 0) && (this->m_page_numbers.at(0)->text().toUTF8() != boost::lexical_cast<string>(this->m_first_page_in_nav_bar + 1)))
          {
            int first_page_in_nav_bar = this->m_first_page_in_nav_bar;

            BOOST_FOREACH(WCustomTableViewPushButton<Result> *b, this->m_page_numbers)
            {
              b->setText(boost::lexical_cast<string>(first_page_in_nav_bar++ + 1));
            }
          }
          string current_page = boost::lexical_cast<string>(this->m_current_page + 1);
          BOOST_FOREACH(WCustomTableViewPushButton<Result> *b, this->m_page_numbers)
          {
            if (b->text().toUTF8() == current_page)
            {
              b->setStyleClass(MIR_STRCAT3(MIR_CSS_PAGE_NAV_BUTTON," ",MIR_CSS_PAGE_NAV_BUTTON_SELECTED));
            }
            else
            {
              b->setStyleClass(MIR_STRINGIFY(MIR_CSS_PAGE_NAV_BUTTON));
            }
          }

        }

      protected:

        virtual WHBoxLayout *create_page_nav_bar()
        {
          WHBoxLayout *layout = new WHBoxLayout();
          int page_count = this->pageCount();
          if (page_count > this->m_pref_num_of_pages_in_nav_bar)
            page_count = this->m_pref_num_of_pages_in_nav_bar;
          this->m_num_of_pages_in_nav_bar = page_count;
          if (this->pageCount() > 1)
          {
            WCustomTableViewPushButton<Result> *wpb = new WCustomTableViewPushButton<Result>(tr(MIR_WCTV_FIRST), this);
            this->m_wpbFirst = wpb;
            layout->addWidget(wpb);
            wpb->setStyleClass(MIR_STRINGIFY(MIR_CSS_PAGE_NAV_BUTTON));
            wpb->clicked().connect(wpb, &WCustomTableViewPushButton<Result>::slt_first_page_clicked);
            wpb = new WCustomTableViewPushButton<Result>(tr(MIR_WCTV_PREV), this);
            layout->addWidget(wpb);
            wpb->setStyleClass(MIR_STRINGIFY(MIR_CSS_PAGE_NAV_BUTTON));
            wpb->clicked().connect(wpb, &WCustomTableViewPushButton<Result>::slt_prev_page_clicked);
            wpb = new WCustomTableViewPushButton<Result>("<", this);
            layout->addWidget(wpb);
            wpb->setStyleClass(MIR_STRINGIFY(MIR_CSS_PAGE_NAV_BUTTON));
            wpb->clicked().connect(wpb, &WCustomTableViewPushButton<Result>::slt_prev_pages_clicked);

            for(int i = this->m_first_page_in_nav_bar; i < this->m_first_page_in_nav_bar + page_count; i++)
            {
              wpb = new WCustomTableViewPushButton<Result>(boost::lexical_cast<string>(i+1), this);
              layout->addWidget(wpb);
              wpb->setStyleClass(MIR_STRINGIFY(MIR_CSS_PAGE_NAV_BUTTON));
              wpb->clicked().connect(wpb, &WCustomTableViewPushButton<Result>::slt_page_clicked);
              this->m_page_numbers.push_back(wpb);
            }

            this->m_last_page_in_nav_bar = this->m_first_page_in_nav_bar + page_count - 1;

            wpb = new WCustomTableViewPushButton<Result>(">", this);
            layout->addWidget(wpb);
            wpb->setStyleClass(MIR_STRINGIFY(MIR_CSS_PAGE_NAV_BUTTON));
            wpb->clicked().connect(wpb, &WCustomTableViewPushButton<Result>::slt_next_pages_clicked);
            wpb = new WCustomTableViewPushButton<Result>(tr(MIR_WCTV_NEXT), this);
            layout->addWidget(wpb);
            wpb->setStyleClass(MIR_STRINGIFY(MIR_CSS_PAGE_NAV_BUTTON));
            wpb->clicked().connect(wpb, &WCustomTableViewPushButton<Result>::slt_next_page_clicked);
            wpb = new WCustomTableViewPushButton<Result>(tr(MIR_WCTV_LAST), this);
            layout->addWidget(wpb);
            wpb->setStyleClass(MIR_STRINGIFY(MIR_CSS_PAGE_NAV_BUTTON));
            wpb->clicked().connect(wpb, &WCustomTableViewPushButton<Result>::slt_last_page_clicked);
          }

          this->setupVisibilityOfWidgets(this->rowCount());

          this->update_page_nav_bar();
          return layout;
        }

      private:
        WTableView                                   *m_wtv;

        WContainerWidget                             *m_page_nav_bar;

        WContainerWidget                             *m_no_results;

        WContainerWidget                             *m_selected_displayed;

        WContainerWidget                             *m_select_inverse_unselect;

        WContainerWidget                             *m_export_all;

        WLineEdit                                    *m_sle;

        WComboBox                                    *m_scb;

        WText                                        *m_txt_selected;

        WText                                        *m_txt_all_displayed;

        WPushButton                                  *m_wpb;

        WCheckBox                                    *m_show_only_selected;

        WCheckBox                                    *m_strict_filtering;

        WPushButton                                  *m_selectAll;

        WPushButton                                  *m_inverseSelection;

        WPushButton                                  *m_unselectAll;

        WPushButton                                  *m_wpb_refresh;

        WPushButton                                  *m_wpb_adv_search;

        WSlider								                	     *m_slider;

        WText                                        *m_no_results_found;

        vector<WCustomTableViewPushButton<Result> *>  m_page_numbers;

        WCustomTableViewPushButton<Result>           *m_wpbFirst;
		
        bool                                          m_checkable;

        int                                           m_first_page_in_nav_bar;

        int                                           m_last_page_in_nav_bar;

        int                                           m_current_page;

        int                                           m_num_of_pages_in_nav_bar;

        int                                           m_pref_num_of_pages_in_nav_bar;

        int                                           m_rows_per_page;

        bool                                          m_nav_bar_created;

        int                                           m_page_count;

	    	int											                      m_row_count;

        int                                           m_whatToShow;

        int                                           m_page_count_reminder;

        WCustomTableView<Result>                     *m_customTableView;
    };

    template <class Result>
    class WCustomTableView : public WCompositeWidget
    {
      public:
        WCustomTableView(WContainerWidget *parent = 0
                         , int whatToShow = (ShowExportAll|ShowSelectionBar|ShowSearchBar|ShowSelectedDisplayed|ShowStrictFiltering|ShowAdvancedSearchAnchor))
          : WCompositeWidget(parent)
        {
          impl_ = new WCustomTableViewImpl<Result>(this, whatToShow);
          setImplementation(impl_);        
        }

        WCustomTableViewImpl<Result> *impl()
        {
          return this->impl_;
        }

      private:
        WCustomTableViewImpl<Result> *impl_;
    };

  }
}
#endif /* _MIR_WCUSTOMTABLEVIEW_H_ */
