#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WLogger>

#include <Wt/WTableView>
#include <Wt/WSlider>
#include <Wt/WHBoxLayout>
#include <Wt/WContainerWidget>
#include <Wt/WText>
#include <Wt/WLineEdit>
#include <Wt/WCssDecorationStyle>
#include <Wt/WCheckBox>
#include <Wt/WPushButton>
#include <Wt/WStandardItemModel>
#include <Wt/WStandardItem>
#include <Wt/Dbo/Dbo>


#include "mir_sp_prezentacja.h"

namespace SyNaT
{
  namespace MIR 
  {
    namespace SP
    {

      using namespace std;
      using namespace Wt;

      Prezentacja::Prezentacja(const WEnvironment& env)
        : WApplication(env), m_firebird(/* YOUR CONNECTION PARAMS HERE */)
      {
	this->messageResourceBundle().use("messresbundle/SyNaTPGmessages");

        this->m_session.setConnection(m_firebird);

        this->m_session.mapClass<NazArtNazAlbItp>("MIR_NAZARTNAZALBITP");

        this->m_transaction = new dbo::Transaction(this->m_session);

        this->setCssTheme("polished");

        this->setTitle("title");

        WContainerWidget *wcw = new WContainerWidget(this->root());
        wcw->setClearSides(Left | Right);
        
        this->m_rows = 20;

         int rows = 1000;
         int columns = 5;


        this->m_wtv = new WCustomTableView<Wt::Dbo::ptr<NazArtNazAlbItp> >();
        this->m_wtv->impl()->setRowsPerPage(this->m_rows);
        SearchModel *qmodel = new SearchModel(this);
        dbo::Query< dbo::ptr<NazArtNazAlbItp> > query =
            m_session.query< dbo::ptr<NazArtNazAlbItp>  >
              ("select u from MIR_NAZARTNAZALBITP u ").where(" u.ART_NAZWA_ARTYSTY = ? ")
		;

	query.bind("Maroon 5"); /* HERE IS THE PROBLEM... 
"Wt: error during event handling: *** IBPP::LogicException ***
Context: Statement::Execute
Message: All parameters must be specified.

"
[2012-Feb-08 10:06:50.051372] 11901 [/wt/SyNaTPG.wt gvBy00oHi2hdaCem] [error] "Wt: fatal error: *** IBPP::LogicException ***
Context: Statement::Execute
Message: All parameters must be specified.

"
*/

        qmodel->setQuery(query);

        qmodel->setBatchSize(1024);

        qmodel->addColumn("NAA_ID", "", ItemIsUserCheckable);
        qmodel->addColumn("ART_NAZWA_ARTYSTY", "");
        qmodel->addColumn("UTW_TYTUL_UTWORU", "");
        qmodel->addColumn("GAT_GATUNEK", "");
        qmodel->addColumn("ALB_NAZWA_ALBUMU", "");
        qmodel->addColumn("UTW_ROK_NAGRANIA", "");
        qmodel->addColumn("UTW_NR_SCIEZKI", "");
        qmodel->addColumn("NAA_ID", "");
        this->m_wtv->impl()->setModel(qmodel);

        m_wtv->impl()->setSortingEnabled(0, false);
        m_wtv->impl()->setSortingEnabled(1, true);
        m_wtv->impl()->setSortingEnabled(2, true);
        m_wtv->impl()->setSortingEnabled(3, true);
        m_wtv->impl()->setSortingEnabled(4, true);
        m_wtv->impl()->setRowHeight(22);
        m_wtv->impl()->setColumnWidth(0, 50);
        int cols = 5, colWidth = 100;
        for (int i = 1; i < cols; i++)
        {
          m_wtv->impl()->setColumnWidth(i, colWidth);
        }
        m_wtv->impl()->resize((cols - 1) * colWidth + (cols - 1) * 7 + 50 + 2 * 7 + 20, 20 + m_rows * 22);
        m_wtv->impl()->setAlternatingRowColors(true);
        m_wtv->impl()->setSelectable(true); 

        WHBoxLayout *layout = new WHBoxLayout();
        layout->addWidget(m_wtv);

	WPushButton *changeLanguage = new WPushButton();
	changeLanguage->setText("Change Lang");
	changeLanguage->clicked().connect(this, &Prezentacja::changeLanguage);
	layout->addWidget(changeLanguage);
        wcw->setLayout(layout, AlignTop | AlignJustify);

	this->setLocale("pl");

      }

      void Prezentacja::changeLanguage()
      {
        this->setLocale("en");
      }

      Prezentacja::~Prezentacja()
      {
            if(this->m_transaction)
            {
              if (this->m_transaction->isActive())
                this->m_transaction->commit();
              delete this->m_transaction;
            }
      }

    } // namespace SP
  } // namespace MIR
} // namespace SyNaT

