#ifndef _MIR_WCUSTOMTABLEVIEWPUSHBUTTON_H_
#define _MIR_WCUSTOMTABLEVIEWPUSHBUTTON_H_

#include <Wt/Dbo/QueryModel>
#include <Wt/WPushButton>
#include <Wt/WSlider>

namespace SyNaT
{
  namespace MIR
  {
    using namespace Wt;

    template <class Result>
    class WCustomTableViewImpl;

    template <class Result>
    class WCustomTableViewPushButton : public WPushButton
    {
      public:
        WCustomTableViewPushButton(WCustomTableViewImpl<Result> *wctv = 0, WContainerWidget *parent = 0)
          : m_wctv(wctv), WPushButton(parent)
        {
        }

        WCustomTableViewPushButton(const WString& text, WCustomTableViewImpl<Result> *wctv = 0, WContainerWidget *parent = 0)
          : m_wctv(wctv), WPushButton(text, parent)
        {
        }

        void slt_first_page_clicked()
        {
          bool nbnu = false;		
          if (this->m_wctv->pageCount() > 0)
          {
            if (this->m_wctv->m_current_page != 0)
              this->m_wctv
                ->scrollTo(
                    this->m_wctv->model()->index(0, 0), WTableView::PositionAtTop);
            this->m_wctv->m_current_page = 0;
            this->m_wctv->m_first_page_in_nav_bar = 0;
            this->m_wctv->m_last_page_in_nav_bar = this->m_wctv->m_num_of_pages_in_nav_bar - 1;
            nbnu = true;
          }
          if (nbnu)
          {
            this->m_wctv->slider().setValue(this->m_wctv->slider().maximum());
//            this->m_wctv->update_slider();
          }
          this->m_wctv->update_page_nav_bar(nbnu);
        }

        void slt_prev_page_clicked()
        {
          bool nbnu = false;
          if (this->m_wctv->pageCount() > 0)
          {
            if (this->m_wctv->m_current_page > 0)
            {
              this->m_wctv
                ->scrollTo(
                    this->m_wctv->model()
                      ->index((--this->m_wctv->m_current_page) * (this->m_wctv->rowsPerPage()), 0), WTableView::PositionAtTop);
              if (this->m_wctv->m_first_page_in_nav_bar > this->m_wctv->m_current_page)
              {
                this->m_wctv->m_first_page_in_nav_bar--;
                this->m_wctv->m_last_page_in_nav_bar--;
                nbnu = true;
              }
              this->m_wctv->slider().setValue((int) (this->m_wctv->slider().maximum() - ((this->m_wctv->m_current_page * 1.0) / (this->m_wctv->pageCount() - 1)) * this->m_wctv->slider().maximum()) );
//              this->m_wctv->update_slider();
            }

          }
          this->m_wctv->update_page_nav_bar(nbnu);
        }

        void slt_next_page_clicked()
        {
          bool nbnu = false;
          if (this->m_wctv->pageCount() > 0)
          {
            if ((this->m_wctv->m_current_page + 1) < (this->m_wctv->pageCount()))
            {
              this->m_wctv
                ->scrollTo(
                    this->m_wctv->model()
                      ->index((++(this->m_wctv->m_current_page)) * (this->m_wctv->rowsPerPage()), 0), WTableView::PositionAtTop);
              if (this->m_wctv->m_last_page_in_nav_bar < this->m_wctv->m_current_page)
              {
                this->m_wctv->m_first_page_in_nav_bar++;
                this->m_wctv->m_last_page_in_nav_bar++;
                nbnu = true;
              }
              this->m_wctv->slider().setValue((int) (this->m_wctv->slider().maximum() - ((this->m_wctv->m_current_page * 1.0) / (this->m_wctv->pageCount() - 1)) * this->m_wctv->slider().maximum()) );
//              this->m_wctv->update_slider();

            }
          }
          this->m_wctv->update_page_nav_bar(nbnu);
        }

        void slt_last_page_clicked()
        {
          bool nbnu = false;
          if (this->m_wctv->pageCount() > 0)
          {
            if (this->m_wctv->m_current_page != (this->m_wctv->pageCount()))
            {
              int pageCount = this->m_wctv->pageCount();
              int currentPage = --pageCount;
              //int row = (pageCount + (this->m_wctv->pageCountReminder() > 0 ? -1 : -2))* this->m_wctv->rowsPerPage();
              int row = currentPage * this->m_wctv->rowsPerPage();
              this->m_wctv
                ->scrollTo(
                    this->m_wctv->model()
                      ->index(row, 0), WTableView::PositionAtTop);
              //this->m_wctv->m_current_page = (pageCount + (this->m_wctv->pageCountReminder() > 0 ? -1 : -2));
              this->m_wctv->m_current_page = currentPage;
              this->m_wctv->m_first_page_in_nav_bar = this->m_wctv->m_current_page - this->m_wctv->m_num_of_pages_in_nav_bar + 1;
              if (this->m_wctv->m_first_page_in_nav_bar < 0)
                this->m_wctv->m_first_page_in_nav_bar = 0;
              this->m_wctv->m_last_page_in_nav_bar = this->m_wctv->m_current_page;
              nbnu = true;
            }

          }
          if (nbnu)
          {
            this->m_wctv->slider().setValue((int) (this->m_wctv->slider().maximum() - ((this->m_wctv->m_current_page * 1.0) / (this->m_wctv->pageCount() - 1)) * this->m_wctv->slider().maximum()) );
//            this->m_wctv->update_slider();
          }
          this->m_wctv->update_page_nav_bar(nbnu);
        }

        void slt_page_clicked()
        {
          bool nbnu = false;
          if (this->m_wctv->pageCount() > 0)
          {
            int page_clicked = boost::lexical_cast<int>(this->text().toUTF8());
            page_clicked--;
            if ((page_clicked < this->m_wctv->pageCount()) && (this->m_wctv->m_current_page != page_clicked))
            {
              this->m_wctv
                ->scrollTo(
                    this->m_wctv->model()
                      ->index(page_clicked * (this->m_wctv->rowsPerPage()), 0), WTableView::PositionAtTop);
              this->m_wctv->m_current_page = page_clicked;
              nbnu = true;
            }
          }
          if (nbnu)
          {
            this->m_wctv->slider().setValue((int) (this->m_wctv->slider().maximum() - ((this->m_wctv->m_current_page * 1.0) / (this->m_wctv->pageCount() - 1)) * this->m_wctv->slider().maximum()) );
//            this->m_wctv->update_slider();
          }
          this->m_wctv->update_page_nav_bar(nbnu);
        }

        void slt_next_pages_clicked()
        {
          if (this->m_wctv->m_last_page_in_nav_bar < (this->m_wctv->pageCount() - this->m_wctv->m_num_of_pages_in_nav_bar))
          {
            this->m_wctv->m_first_page_in_nav_bar += this->m_wctv->m_num_of_pages_in_nav_bar;
            this->m_wctv->m_last_page_in_nav_bar += this->m_wctv->m_num_of_pages_in_nav_bar;
            this->m_wctv->update_page_nav_bar(true);
          }
          else if (this->m_wctv->m_last_page_in_nav_bar < (this->m_wctv->pageCount() - 1))
          {
            this->m_wctv->m_first_page_in_nav_bar = this->m_wctv->pageCount() - this->m_wctv->m_num_of_pages_in_nav_bar;
            this->m_wctv->m_last_page_in_nav_bar = this->m_wctv->pageCount() - 1;
            this->m_wctv->update_page_nav_bar(true);
          }
        }

        void slt_prev_pages_clicked()
        {
          if (this->m_wctv->m_first_page_in_nav_bar >= this->m_wctv->m_num_of_pages_in_nav_bar)
          {
            this->m_wctv->m_first_page_in_nav_bar -= this->m_wctv->m_num_of_pages_in_nav_bar;
            this->m_wctv->m_last_page_in_nav_bar -= this->m_wctv->m_num_of_pages_in_nav_bar;
            this->m_wctv->update_page_nav_bar(true);
          }
          else if ((this->m_wctv->m_first_page_in_nav_bar < this->m_wctv->m_num_of_pages_in_nav_bar)
                  && (this->m_wctv->m_first_page_in_nav_bar > 0))
          {
            this->m_wctv->m_first_page_in_nav_bar = 0;
            this->m_wctv->m_last_page_in_nav_bar = this->m_wctv->m_num_of_pages_in_nav_bar - 1;
            this->m_wctv->update_page_nav_bar(true);
          }
        }


      protected:
        WCustomTableViewImpl<Result> *m_wctv;
    };
  }
}


#endif /* _MIR_WCUSTOMTABLEVIEWPUSHBUTTON_H_ */
