#include <Wt/WApplication>
#include <Wt/WCheckBox>
#include <Wt/WGridLayout>
#include <Wt/WVBoxLayout>
#include <Wt/WHBoxLayout>
#include <Wt/WGroupBox>
#include <Wt/WContainerWidget>
#include <Wt/WLabel>
#include <Wt/WScrollArea>

class HelloApp : public Wt::WApplication
{
public:
    HelloApp(const Wt::WEnvironment& env):
        Wt::WApplication(env)
    {
	  // main grid layout
	  Wt::WGridLayout* pGridLayout = new Wt::WGridLayout();
	  root()->setLayout( pGridLayout );

	  // widget to main grid layout
	  Wt::WContainerWidget* pContainer = new Wt::WContainerWidget();
	  pContainer->addWidget( new Wt::WLabel( "Cell ( 0, 0 ) of main grid layout" ) );
	  pGridLayout->addWidget( pContainer, 0, 0 );

	  // horizontal layout to main grid layout
	  Wt::WHBoxLayout* pHBLayout = new Wt::WHBoxLayout();
	  pGridLayout->addLayout( pHBLayout, 1, 0, 0, 2 );
	  pGridLayout->setRowStretch( 1, 1 );
	  pGridLayout->setColumnStretch( 0, 1 );

	  // first widget to horizontal layout
	  pContainer = new Wt::WContainerWidget();
	  pContainer->addWidget( new Wt::WLabel( "First widget in horizontal layout" ) );
	  pHBLayout->addWidget( pContainer );
	  pHBLayout->setResizable( 0 );

	  // second widget to horizontal layout
	  pContainer = new Wt::WContainerWidget();
	  pHBLayout->addWidget( pContainer, 1 );
	  Wt::WVBoxLayout* pVBLayout = new Wt::WVBoxLayout();
	  // which has vertical layout
	  pContainer->setLayout( pVBLayout );
	  pContainer = new Wt::WContainerWidget();
	  pVBLayout->addWidget( pContainer );
	  pVBLayout->addStretch( 1 );
	  
	  // with another container with vertical layout
	  pVBLayout = new Wt::WVBoxLayout();
	  pContainer->setLayout( pVBLayout );
      
      Wt::WGroupBox* pGroupBox = new Wt::WGroupBox();

      Wt::WCheckBox *m_pCheck1 = new Wt::WCheckBox();
      Wt::WCheckBox *m_pCheck2 = new Wt::WCheckBox();
      Wt::WCheckBox *m_pCheck3 = new Wt::WCheckBox();
      Wt::WCheckBox *m_pCheck4 = new Wt::WCheckBox();
      Wt::WCheckBox *m_pCheck5 = new Wt::WCheckBox();

	  pGridLayout = new Wt::WGridLayout();
      pGroupBox->setLayout( pGridLayout );
      pGroupBox->setTitle( Wt::WString( "Panel" ) );
      m_pCheck1->setText( Wt::WString( "Checkbox1" ) );
      m_pCheck2->setText( Wt::WString( "Checkbox2" ) );
      m_pCheck3->setText( Wt::WString( "Checkbox3" ) );
      pGridLayout->addWidget( m_pCheck1, 0, 0, 0, 0,
			      Wt::AlignLeft | Wt::AlignTop );
      pGridLayout->addWidget( m_pCheck2, 1, 0, 0, 0,
			      Wt::AlignLeft | Wt::AlignTop );
      pGridLayout->addWidget( m_pCheck3, 2, 0, 0, 0,
			      Wt::AlignLeft | Wt::AlignTop );
      m_pCheck4->setText( Wt::WString( "Checkbox4" ) );
      m_pCheck5->setText( Wt::WString( "Checkbox5" ) );
      pGridLayout->addWidget( m_pCheck4, 0, 1, 0, 0,
			      Wt::AlignLeft | Wt::AlignTop );
      pGridLayout->addWidget( m_pCheck5, 1, 1, 0, 0,
			      Wt::AlignLeft | Wt::AlignTop );

	  Wt::WScrollArea* pScroll = new Wt::WScrollArea();
	  pScroll->setScrollBarPolicy( Wt::WScrollArea::ScrollBarAsNeeded );
	  pScroll->setWidget( pGroupBox );

      pVBLayout->addWidget( pScroll );
	  pVBLayout->addStretch( 1 );
    }
};

Wt::WApplication *createApplication(const Wt::WEnvironment& env)
{
    return new HelloApp(env);
}

int main(int argc, char **argv)
{
    return Wt::WRun(argc, argv, &createApplication);
}

