#ifndef _MIR_MENUANDCONTENTS_H_
#define _MIR_MENUANDCONTENTS_H_
/*
 * Copyright (c) 2011,
 * Technical University Of Gdansk,
 * Faculty of Electronics, Telecommunications and Informatics,
 * Multimedia Systems Department
 * and/or its affiliates. All rights reserved.
 */

#include <Wt/WContainerWidget>
#include <Wt/WMenu>
#include <Wt/WString>
#include <Wt/WPushButton>

#include "controls/mir_sp_controlswidget.h"
#include "mir_sp_synatpgapp.h"

namespace SyNaT
{
  namespace MIR
  {
    namespace SP
    {
      using namespace Wt;

      class MenuAndContents : public Wt::WContainerWidget
      {
        public:
          MenuAndContents(SyNaTPGApp *app);

          virtual ~MenuAndContents()
          {
          }

          WMenuItem *addToMenu(Wt::WMenu *menu, const WString& name,
             ControlsWidget *controls);

          static WMenuItem *static_addToMenu(Wt::WMenu *menu, const WString& name,
             ControlsWidget *controls);

          void slt_menuItemSelected(WMenuItem *mi);

          void slt_localeAboutToBeChangedToPl();

          void slt_localeAboutToBeChangedToEn();
        private:

          Wt::WStackedWidget *m_contentsStack_;
          SyNaTPGApp         *m_app;

          WPushButton        *m_localeChanger_en;
          WPushButton        *m_localeChanger_pl;
      };
    }
  }
}


#endif // _MIR_MENUANDCONTENTS_H_
