#include <locale>

#include <Wt/WLogger>
#include <Wt/WMenu>
#include <Wt/WSubMenuItem>
#include <Wt/WVBoxLayout>
#include <Wt/WPushButton>
#include <Wt/WStackedWidget>
#include <Wt/WContainerWidget>
#include <Wt/WText>
#include <Wt/WImage>
#include <Wt/WTableCell>
#include <Wt/WTable>

#include "utils/mir_trkeys.h"
#include "utils/mir_cssconsts.h"
#include "utils/mir_cssclasses.h"
#include "utils/mir_internalpaths.h"
#include "controls/mir_sp_controlswidget.h"
#include "mir_sp_menuandcontents.h"

namespace SyNaT
{
  namespace MIR
  {
    namespace SP
    {
      using namespace Wt;

      MenuAndContents::MenuAndContents(SyNaTPGApp *app)
        : WContainerWidget(), m_app(app)
      {
        this->setWidth(WLength(100, WLength::Percentage));
        this->m_contentsStack_ = new WStackedWidget();
        WAnimation fade(WAnimation::Fade, WAnimation::Linear, 250);
        this->m_contentsStack_->setTransitionAnimation(fade);
        // Show scrollbars when needed ...
        //this->m_contentsStack_->setOverflow(WContainerWidget::OverflowAuto);
        this->m_contentsStack_->setWidth(WLength(100, WLength::Percentage));
        // ... and work around a bug in IE (see setOverflow() documentation)
        //this->m_contentsStack_->setPositionScheme(Static);
        this->m_contentsStack_->setStyleClass(MIR_STRCAT3(MIR_CSS_CONTENTS," ",MIR_CSS_MAIN_PAGE));
        /*
         * Setup the menu (and submenus)
         */
        WMenu *menu = new WMenu(this->m_contentsStack_, Horizontal, 0);
        menu->setRenderAsList(true);
        menu->setStyleClass(MIR_STRINGIFY(MIR_CSS_MENU_DROPDOWN));
        menu->setInternalPathEnabled();
        //menu->setInternalBasePath("/");
        WMenuItem *mi;
        // tutaj tworzę wszystkie dostępne menu, ale schowane (tzn. WMenuItem->hide())

        mi = menu->addItem(tr(MIR_MENU_SIGNIN), new ControlsWidget(false, MIR_STRINGIFY(MIR_CSS_MARGIN_FOR_ANIM)));
        mi->itemWidget()->parent()->setStyleClass(MIR_STRCAT3(MIR_CSS_MENU_DIR," ", MIR_CSS_DISPLAY_NONE));
        mi->setPathComponent(MIR_IPATH_SIGNIN);

        mi = this->addToMenu(menu, tr(MIR_MENU_SIGNOUT), new ControlsWidget(false, MIR_STRINGIFY(MIR_CSS_MARGIN_FOR_ANIM)));
        mi->setPathComponent(MIR_IPATH_SIGNOUT);
        mi->itemWidget()->parent()->setStyleClass(MIR_STRINGIFY(MIR_CSS_MENU_DIR));

        mi = this->addToMenu(menu, tr(MIR_MENU_HELP), new ControlsWidget(false, MIR_STRINGIFY(MIR_CSS_MARGIN_FOR_ANIM)));
        mi->setPathComponent(MIR_IPATH_HELP);
        mi->itemWidget()->parent()->setStyleClass(MIR_STRINGIFY(MIR_CSS_MENU_DIR));

        mi = this->addToMenu(menu, tr(MIR_MENU_SETTINGS), new ControlsWidget(false, MIR_STRINGIFY(MIR_CSS_MARGIN_FOR_ANIM)));
        mi->setPathComponent(MIR_IPATH_SETTINGS);
        mi->itemWidget()->parent()->setStyleClass(MIR_STRINGIFY(MIR_CSS_MENU_DIR));

        mi = this->addToMenu(menu, tr(MIR_MENU_EXPLORER), new ControlsWidget(false, MIR_STRINGIFY(MIR_CSS_MARGIN_FOR_ANIM)));
        mi->itemWidget()->parent()->setStyleClass(MIR_STRCAT3(MIR_CSS_MENU_DIR, " ", MIR_CSS_HOME_BACKGROUND));
        mi->setPathComponent(MIR_IPATH_EXPLORER);
        /*
         * Add it all inside a layout
         */
        WTable *outerTable = new WTable(this);
        outerTable->setWidth(WLength(100, WLength::Percentage));
        WContainerWidget *wcwVertLayout = new WContainerWidget();
        wcwVertLayout->setWidth(WLength(100, WLength::Percentage));
        WVBoxLayout *vertLayout = new WVBoxLayout();
        vertLayout->addWidget(m_contentsStack_, -1);
        wcwVertLayout->setLayout(vertLayout);

        this->m_localeChanger_en = new WPushButton();
        this->m_localeChanger_en->setStyleClass(MIR_STRINGIFY(MIR_CSS_LANG_BUTTON) " " MIR_STRINGIFY(MIR_CSS_LANG_BUTTON) "_en");
        this->m_localeChanger_en->clicked().connect(this, &MenuAndContents::slt_localeAboutToBeChangedToEn);
        this->m_localeChanger_pl = new WPushButton();
        this->m_localeChanger_pl->setStyleClass(MIR_STRINGIFY(MIR_CSS_LANG_BUTTON) " " MIR_STRINGIFY(MIR_CSS_LANG_BUTTON) "_pl");
        this->m_localeChanger_pl->clicked().connect(this, &MenuAndContents::slt_localeAboutToBeChangedToPl);

        WContainerWidget *wcw = new WContainerWidget();
        WContainerWidget *wcw1 = new WContainerWidget();
        wcw1->setClearSides(Left | Right);
        wcw1->addWidget(new WImage(WLink(MIR_SYNAT_LOGO)));

        WContainerWidget *wcw2 = new WContainerWidget();
        wcw2->setClearSides(Left | Right);
        wcw2->setStyleClass(MIR_STRINGIFY(MIR_CSS_MENU));
        wcw2->addWidget(this->m_localeChanger_en);
        wcw2->addWidget(this->m_localeChanger_pl);
        wcw2->addWidget(menu);

        wcw->addWidget(wcw1);
        wcw->addWidget(wcw2);
        wcw->setWidth(WLength(100, WLength::Percentage));
        outerTable->elementAt(0, 0)->addWidget(wcw);

        outerTable->elementAt(1, 0)->addWidget(wcwVertLayout);
        //outerTable->elementAt(1, 0)->setHeight(WLength(100, WLength::Percentage));
        //outerTable->elementAt(1, 0)->setVerticalAlignment(AlignMiddle);

        wcw = new WContainerWidget();
        wcw->setClearSides(Left | Right);

        WTable *wt = new WTable(wcw);
        wt->elementAt(0, 0)->addWidget(new WImage(WLink(MIR_SYNAT_STOPKA)));
        wt->setWidth(WLength(900, WLength::Pixel));  
        wt->setStyleClass(MIR_STRINGIFY(MIR_CSS_CENTERED));
        wcw->setWidth(WLength(100, WLength::Percentage));

        outerTable->elementAt(2, 0)->addWidget(wcw);

        //outerLayout->addLayout(vertLayout, 1);
		//vertOuterLayout->setResizable(0, true);
      }

      void MenuAndContents::slt_localeAboutToBeChangedToEn()
      {
        this->m_app->setLocale("en");
      }

      void MenuAndContents::slt_localeAboutToBeChangedToPl()
      {
        this->m_app->setLocale("pl");
      }

      WMenuItem *MenuAndContents::addToMenu(WMenu *menu, const WString& name,
                  ControlsWidget *controls)
      {
        if (controls->hasSubMenu())
        {
          WSubMenuItem *smi = new WSubMenuItem(name, controls);
          WMenu *subMenu = new WMenu(menu->contentsStack()/*contentsStack_*/, Vertical, 0);
          subMenu->setRenderAsList(true);

          smi->setSubMenu(subMenu);
          WMenuItem *wmi = menu->addItem(smi);

          subMenu->setInternalPathEnabled();
          subMenu->setInternalBasePath("/" + smi->pathComponent());
//          subMenu->setStyleClass(MIR_STRCAT3(MIR_CSS_MENU," ",MIR_CSS_SUBMENU));

          controls->populateSubMenu(subMenu);
          return wmi;
        }
        else
        {
          return menu->addItem(name, controls);
        }
      }

      WMenuItem *MenuAndContents::static_addToMenu(WMenu *menu, const WString& name,
                  ControlsWidget *controls)
      {
        if (controls->hasSubMenu())
        {
          WSubMenuItem *smi = new WSubMenuItem(name, controls);
          WMenu *subMenu = new WMenu(menu->contentsStack()/*contentsStack_*/, Vertical, 0);
          subMenu->setRenderAsList(true);

          smi->setSubMenu(subMenu);
          WMenuItem *wmi = menu->addItem(smi);

          subMenu->setInternalPathEnabled();
//          subMenu->setInternalBasePath("/" + smi->pathComponent());
          subMenu->setStyleClass(MIR_STRCAT3(MIR_CSS_MENU," ",MIR_CSS_SUBMENU));

          controls->populateSubMenu(subMenu);
          return wmi;
        }
        else
        {
          return menu->addItem(name, controls);
        }
      }

    }
  }
}
