#include <Wt/WApplication>
#include <Wt/WText>
#include <Wt/WProgressBar>
#include <Wt/WPushButton>
#include <Wt/WTimer>
#include <Wt/WTextArea>
#include <Wt/WAnchor>
#include <Wt/WMessageBox>
#include <Wt/WLabel>
#include <Wt/WContainerWidget>
#include <Wt/WLogger>
#include <Wt/WWidget>
#include <Wt/WTable>
#include <Wt/WEnvironment>
#include <Wt/WLoadingIndicator>

#include <sstream>

#include <boost/foreach.hpp>
#include <boost/regex.hpp>
#include <boost/ptr_container/ptr_vector.hpp>
#include <boost/ptr_container/ptr_map.hpp>
#include <boost/thread/mutex.hpp>
#include <boost/filesystem.hpp>
#include <boost/interprocess/shared_memory_object.hpp>
#include <boost/interprocess/mapped_region.hpp>
#include <boost/interprocess/sync/named_mutex.hpp>
#include <boost/interprocess/sync/scoped_lock.hpp>
#include <boost/scoped_ptr.hpp>
#include <boost/bind.hpp>

#include "utils/mir_trkeys.h"
#include "utils/mir_defines.h"
#include "utils/mir_cssclasses.h"
#include "utils/mir_internalpaths.h"
#include "mir_sp_menuandcontents.h"
#include "mir_sp_synatpgapp.h"

namespace SyNaT
{
  namespace MIR 
  {
    namespace SP
    {

      using namespace std;
      using namespace Wt;
      using namespace boost::filesystem;
      using namespace boost::interprocess;

      SyNaTPGApp::SyNaTPGApp(const WEnvironment& env)
        : WApplication(env)
      {
        
        this->addMetaHeader("viewport", "width=700, height=1200");

        this->setCssTheme("polished");

        this->useStyleSheet("style/menu.css");

        WTable *table = new WTable(this->root());
        table->setWidth(WLength(100, WLength::Percentage));

	    table->elementAt(0, 0)->addWidget(new MenuAndContents(this));
	    table->elementAt(0, 0)->setWidth(WLength(100, WLength::Percentage));

      }

      SyNaTPGApp::~SyNaTPGApp()
      {
      }

    } // namespace SP
  } // namespace MIR
} // namespace SyNaT
