#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WSlider>
#include <Wt/WVBoxLayout>

using namespace Wt;

class HelloApplication : public WApplication
{
public:
  HelloApplication(const WEnvironment& env);

};

HelloApplication::HelloApplication(const WEnvironment& env)
  : WApplication(env)
{
  this->setLayoutDirection(Wt::RightToLeft);

  WSlider *sliderHorizontal = new WSlider(Horizontal);
  sliderHorizontal->setRange(0,100);
  sliderHorizontal->setValue(10);
  sliderHorizontal->setTickInterval(5);
  sliderHorizontal->setTickPosition(WSlider::TicksBothSides);
  sliderHorizontal->resize(300, 50);
  WVBoxLayout *vBoxLayout = new WVBoxLayout(root());
  vBoxLayout->addWidget(sliderHorizontal);
  root()->setLayout(vBoxLayout);
}

WApplication *createApplication(const WEnvironment& env)
{
  return new HelloApplication(env);
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, &createApplication);
}

