#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WSlider>
#include <Wt/WGridLayout>

using namespace Wt;

class HelloApplication : public WApplication
{
public:
  HelloApplication(const WEnvironment& env);
  void vSliderMoved(int i);
  void hSliderMoved(int i);
};

HelloApplication::HelloApplication(const WEnvironment& env)
  : WApplication(env)
{
  this->setLayoutDirection(Wt::RightToLeft);

  WSlider *sliderH = new WSlider(Horizontal);
  sliderH->setRange(0,100);
  sliderH->setValue(10);
  sliderH->setTickInterval(5);
  sliderH->setTickPosition(WSlider::TicksBothSides);
  sliderH->resize(300, 50);

  sliderH->sliderMoved().connect(this, &HelloApplication::hSliderMoved);

  WSlider *sliderV = new WSlider(Vertical);
  sliderV->setRange(0,100);
  sliderV->setValue(10);
  sliderV->setTickInterval(5);
  sliderV->setTickPosition(WSlider::TicksBothSides);
  sliderV->resize(50, 300);
  
  sliderV->sliderMoved().connect(this, &HelloApplication::vSliderMoved);

  WGridLayout *gridLayout = new WGridLayout(this->root());
  gridLayout->addWidget(sliderH,1,1);
  gridLayout->addWidget(sliderV,3,3);
}

void HelloApplication::vSliderMoved(int i)
{
  std::cerr << "vSliderMoved" << i << std::endl;
}

void HelloApplication::hSliderMoved(int i)
{
  std::cerr << "hSliderMoved" << i << std::endl;
}

WApplication *createApplication(const WEnvironment& env)
{
  return new HelloApplication(env);
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, &createApplication);
}

