#include <Wt/WApplication.h>
#include <Wt/WBootstrap5Theme.h>
#include <Wt/WServer.h>

#include <Wt/WContainerWidget.h>
#include <Wt/WTemplate.h>
#include <Wt/WLineEdit.h>


using namespace Wt;

extern char **environ;


// -----------------------------------------------------------------------------------
std::unique_ptr<WApplication> createHelloApplication(const WEnvironment &env)
{
  auto app = std::make_unique<WApplication>(env);

  auto theme = std::make_shared<WBootstrap5Theme>();
  app->setTheme(theme);

  WString floatTempl = "<div class='form-floating'> ${InputWidget}"
                       "<label for=\"${id:InputWidget}\">${MainLabel}</label> </div>";

  for (int i = 0; i < 5; i++)
  {
    auto userTemplate = app->root()->addWidget(std::make_unique<WTemplate>(floatTempl));
    userTemplate->addFunction("id", &WTemplate::Functions::id);

    userTemplate->setMargin(10, Side::Bottom);
    userTemplate->setMaximumSize(400, WLength::Auto);

    auto userEdit = userTemplate->bindWidget("InputWidget", std::make_unique<WLineEdit>());
    userEdit->setMaxLength(64);
    userEdit->setPlaceholderText(" ");  // Required damit es floated

    userTemplate->bindString("MainLabel", "Floating Label Field " + std::to_string(i));
  }

  return app;
}


// -----------------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  try
  {
    WServer server(argc, argv, WTHTTP_CONFIGURATION);

    server.addEntryPoint(EntryPointType::Application,
                         std::bind(&createHelloApplication, std::placeholders::_1));

    if (server.start())
    {
      int sig = WServer::waitForShutdown();

      std::cerr << "*** Shutdown (signal = " << sig << ")" << std::endl;
      server.stop();

      if (sig == 1) // SIGHUP
        WServer::restart(argc, argv, environ);

      return 0;
    }
  }
  catch (WServer::Exception &e)
  {
    std::cerr << "*** Server Exception: " << e.what() << std::endl;
  }
  catch (std::exception &e)
  {
    std::cerr << "*** Std Exception: " << e.what() << std::endl;
  }
}
