#include <Wt/WObject>
#include <Wt/WApplication>
#include <Wt/WLogger>
#include <Wt/WStreamResource>
#include <Wt/Http/Request>
#include <Wt/Http/Response>
#include <hpdf.h>
#include <Wt/Render/WPdfRenderer>

#include <string>
#include <sstream>
#include <iostream>
#include <fstream>

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/fstream.hpp>

#include "mir_sp_paramselresource.h"


extern "C" {
  HPDF_STATUS HPDF_UseUTFEncodings(HPDF_Doc pdf);
}


namespace SyNaT
{
  namespace MIR
  {
    namespace SP
    {
      using namespace Wt;
      using namespace std;
      using namespace boost::filesystem;

      void ParamsSelResource::handleRequest(const Wt::Http::Request& request,
                         Wt::Http::Response& response)
      {
        if (!request.continuation())
        {
          try
          {
            if (!this->m_path_to_params_file.empty())
            {
              try
              {
                boost::filesystem::remove(this->m_path_to_params_file);
              }
              catch(std::exception &e)
              {
                WApplication::instance()->log("error") << e.what();
              }
            }

            this->m_path_to_params_file = temp_directory_path() /= unique_path("%%%%%%%%%%%%%%%%");
            this->createPdfFile();
          }
          catch(std::exception &e)
          {
            WApplication::instance()->log("error") << e.what();
          }
        }
        if (!this->m_path_to_params_file.empty())
        {
          if (!request.continuation())
          {
            this->suggestFileName("vector_of_params.pdf");

            this->setMimeType("application/x-pdf");
          }
          try
          {
            boost::filesystem::ifstream f(this->m_path_to_params_file, std::ios_base::in | std::ios_base::binary);
            this->handleRequestPiecewise(request, response, f);
          }
          catch(std::exception &e)
          {
            WApplication::instance()->log("error") << e.what();
          }
        }
      }

      void ParamsSelResource::createPdfFile()
      {

        HPDF_Doc pdf = HPDF_New(&ParamsSelResource::error_handler, 0);

        HPDF_SetCompressionMode(pdf, HPDF_COMP_ALL);

        HPDF_UseUTFEncodings(pdf);

        HPDF_Page page = HPDF_AddPage(pdf);
        HPDF_Page_SetSize(page, HPDF_PAGE_SIZE_A3, HPDF_PAGE_LANDSCAPE);

        Render::WPdfRenderer renderer(pdf, page);

        renderer.addFontCollection("/usr/share/fonts/truetype");

        renderer.setMargin(0.54);
        renderer.setDpi(300);

        renderer.render(WString::fromUTF8("<table border=\"1\" cellspacing=\"0\" style=\"font-size: 3mm\"><tr style=\"font-weight: bold\"><td>Nazwa artysty</td><td>TC</td><td>3RMS_TCD_10FR_VAR</td><td>3RMS_TCD_10FR_MEAN</td><td>2RMS_TCD_10FR_VAR</td><td>2RMS_TCD_10FR_MEAN</td><td>1RMS_TCD_10FR_VAR</td><td>1RMS_TCD_10FR_MEAN</td><td>ZCD_10FR_VAR</td><td>ZCD_10FR_MEAN</td><td>2RMS_TCD</td><td>ZCD</td><td>PEAK_RMS10FR_MEAN</td><td>PEAK_RMS_TOT</td><td>THR_2RMS_10FR_MEAN</td><td>THR_3RMS_TOT</td><td>THR_1RMS_TOT</td><td>MFCCV20</td><td>MFCCV19</td><td>MFCCV18</td><td>MFCCV17</td><td>MFCCV16</td><td>MFCCV15</td><td>MFCCV14</td><td>MFCCV13</td><td>MFCCV12</td><td>MFCCV11</td><td>MFCCV10</td><td>MFCCV9</td><td>MFCCV8</td><td>MFCCV7</td><td>MFCCV6</td><td>MFCCV5</td><td>MFCCV4</td><td>MFCCV3</td><td>MFCCV2</td><td>MFCCV1</td><td>MFCC20</td><td>MFCC19</td><td>MFCC18</td></tr><tr><td>Maroon 5</td><td>15,422544</td><td>0,000002</td><td>0,002006</td><td>0,000009</td><td>0,012022</td><td>0,000192</td><td>0,040594</td><td>0,000480</td><td>0,081977</td><td>0,012649</td><td>0,081980</td><td>2,940254</td><td>-3,591407</td><td>0,056715</td><td>0,005966</td><td>0,290253</td><td>0,016914</td><td>0,048300</td><td>0,033658</td><td>0,018153</td><td>0,029982</td><td>0,016309</td><td>0,011161</td><td>0,015188</td><td>0,015126</td><td>0,014725</td><td>0,011479</td><td>0,012296</td><td>0,011050</td><td>0,011586</td><td>0,008665</td><td>0,017034</td><td>0,022572</td><td>0,039769</td><td>0,054292</td><td>0,066582</td><td>0,045326</td><td>0,111442</td><td>0,169298</td></tr><tr><td>Green Day</td><td>16,402573</td><td>0,000001</td><td>0,002402</td><td>0,000000</td><td>0,010083</td><td>0,000026</td><td>0,031269</td><td>0,000082</td><td>0,062261</td><td>0,010051</td><td>0,062261</td><td>4,738534</td><td>4,808776</td><td>0,057342</td><td>0,009320</td><td>0,272566</td><td>0,013052</td><td>0,016398</td><td>0,021396</td><td>0,013686</td><td>0,011912</td><td>0,012402</td><td>0,008765</td><td>0,012212</td><td>0,014274</td><td>0,012044</td><td>0,011460</td><td>0,009297</td><td>0,013450</td><td>0,012261</td><td>0,012082</td><td>0,018109</td><td>0,015146</td><td>0,025716</td><td>0,039846</td><td>0,051810</td><td>0,058146</td><td>-0,031985</td><td>-0,102366</td></tr><tr><td>Ziggy Marley</td><td>14,924334</td><td>0,000000</td><td>0,002320</td><td>0,000005</td><td>0,011003</td><td>0,000058</td><td>0,037695</td><td>0,000105</td><td>0,082729</td><td>0,011369</td><td>0,082729</td><td>0,718362</td><td>-3,739785</td><td>0,060075</td><td>0,010593</td><td>0,271929</td><td>0,008934</td><td>0,012092</td><td>0,010366</td><td>0,007239</td><td>0,005307</td><td>0,005789</td><td>0,006400</td><td>0,007157</td><td>0,007969</td><td>0,006452</td><td>0,008270</td><td>0,008214</td><td>0,009873</td><td>0,010134</td><td>0,016298</td><td>0,024426</td><td>0,025824</td><td>0,073025</td><td>0,039574</td><td>0,049929</td><td>-0,016003</td><td>-0,014929</td><td>-0,019747</td></tr><tr><td>On The Rocks</td><td>17,629869</td><td>0,000000</td><td>0,001047</td><td>0,000001</td><td>0,008433</td><td>0,000016</td><td>0,036016</td><td>0,000047</td><td>0,060720</td><td>0,008635</td><td>0,060724</td><td>4,516873</td><td>5,867246</td><td>0,048083</td><td>0,006442</td><td>0,293857</td><td>0,005279</td><td>0,004573</td><td>0,003687</td><td>0,005424</td><td>0,007971</td><td>0,010202</td><td>0,006542</td><td>0,003808</td><td>0,005308</td><td>0,004558</td><td>0,005413</td><td>0,007258</td><td>0,014523</td><td>0,004966</td><td>0,006854</td><td>0,006646</td><td>0,014819</td><td>0,029014</td><td>0,014743</td><td>0,019550</td><td>0,008438</td><td>-0,026689</td><td>-0,057152</td></tr><tr><td>Relaxing Sounds</td><td>16,040571</td><td>0,000000</td><td>0,001842</td><td>0,000001</td><td>0,009079</td><td>0,000015</td><td>0,030848</td><td>0,000056</td><td>0,059569</td><td>0,008838</td><td>0,059571</td><td>5,658804</td><td>7,311213</td><td>0,055652</td><td>0,009430</td><td>0,272254</td><td>0,001984</td><td>0,002075</td><td>0,003886</td><td>0,002432</td><td>0,004181</td><td>0,002467</td><td>0,002371</td><td>0,003615</td><td>0,003829</td><td>0,004522</td><td>0,009051</td><td>0,007738</td><td>0,007140</td><td>0,010361</td><td>0,011246</td><td>0,009794</td><td>0,012983</td><td>0,025710</td><td>0,020303</td><td>0,031895</td><td>0,005935</td><td>0,008470</td><td>-0,004448</td></tr><tr><td>Josh Groban</td><td>12,606753</td><td>0,000001</td><td>0,000897</td><td>0,000002</td><td>0,004236</td><td>0,000007</td><td>0,012349</td><td>0,000137</td><td>0,026868</td><td>0,003767</td><td>0,026868</td><td>4,912837</td><td>7,043452</td><td>0,055824</td><td>0,009999</td><td>0,271134</td><td>0,006353</td><td>0,011341</td><td>0,011495</td><td>0,007249</td><td>0,003909</td><td>0,003143</td><td>0,003802</td><td>0,006648</td><td>0,009532</td><td>0,007182</td><td>0,004978</td><td>0,005509</td><td>0,005479</td><td>0,006029</td><td>0,008456</td><td>0,007887</td><td>0,012508</td><td>0,021969</td><td>0,019166</td><td>0,034383</td><td>-0,040093</td><td>-0,020017</td><td>-0,004259</td></tr><tr><td>Philharmonic Orchestra Bratislava</td><td>18,895250</td><td>0,000000</td><td>0,001104</td><td>0,000009</td><td>0,008019</td><td>0,000186</td><td>0,034547</td><td>0,000475</td><td>0,064879</td><td>0,008816</td><td>0,064880</td><td>4,749698</td><td>9,875766</td><td>0,050036</td><td>0,019295</td><td>0,204802</td><td>0,002137</td><td>0,003572</td><td>0,002712</td><td>0,001574</td><td>0,002119</td><td>0,002496</td><td>0,001721</td><td>0,001560</td><td>0,001774</td><td>0,001867</td><td>0,001619</td><td>0,001359</td><td>0,001682</td><td>0,002533</td><td>0,002235</td><td>0,001960</td><td>0,001976</td><td>0,003297</td><td>0,007904</td><td>0,035329</td><td>0,003728</td><td>0,000800</td><td>-0,012167</td></tr><tr><td>Kidsongs Kids</td><td>15,304280</td><td>0,000001</td><td>0,003497</td><td>0,000025</td><td>0,012256</td><td>0,000074</td><td>0,037441</td><td>0,000104</td><td>0,095502</td><td>0,014396</td><td>0,095503</td><td>7,106685</td><td>11,194115</td><td>0,062483</td><td>0,026777</td><td>0,166874</td><td>0,003401</td><td>0,002933</td><td>0,006798</td><td>0,002533</td><td>0,004497</td><td>0,002898</td><td>0,003476</td><td>0,001862</td><td>0,002583</td><td>0,006547</td><td>0,004784</td><td>0,003022</td><td>0,002116</td><td>0,002734</td><td>0,003045</td><td>0,003082</td><td>0,002745</td><td>0,005853</td><td>0,008933</td><td>0,050192</td><td>-0,024872</td><td>-0,044104</td><td>-0,047169</td></tr><tr><td>On The Rocks</td><td>13,155066</td><td>0,000001</td><td>0,003245</td><td>0,000008</td><td>0,009724</td><td>0,000087</td><td>0,032307</td><td>0,000290</td><td>0,068634</td><td>0,010579</td><td>0,068634</td><td>6,083377</td><td>7,035910</td><td>0,055227</td><td>0,014714</td><td>0,248874</td><td>0,007118</td><td>0,009214</td><td>0,009788</td><td>0,006566</td><td>0,004784</td><td>0,006043</td><td>0,005173</td><td>0,004326</td><td>0,004810</td><td>0,005698</td><td>0,004345</td><td>0,004424</td><td>0,005221</td><td>0,004572</td><td>0,006930</td><td>0,009954</td><td>0,012444</td><td>0,031811</td><td>0,029194</td><td>0,082824</td><td>0,019145</td><td>0,000424</td><td>-0,019235</td></tr><tr><td>Enrique Iglesias</td><td>13,874555</td><td>0,000006</td><td>0,003117</td><td>0,000021</td><td>0,014701</td><td>0,000202</td><td>0,050904</td><td>0,000995</td><td>0,096489</td><td>0,013194</td><td>0,096493</td><td>-1,810322</td><td>-3,770771</td><td>0,053855</td><td>0,007938</td><td>0,287783</td><td>0,004736</td><td>0,006619</td><td>0,004633</td><td>0,005892</td><td>0,008078</td><td>0,006057</td><td>0,005793</td><td>0,005058</td><td>0,004780</td><td>0,007352</td><td>0,005818</td><td>0,007594</td><td>0,009202</td><td>0,008101</td><td>0,008720</td><td>0,009408</td><td>0,015885</td><td>0,030030</td><td>0,032821</td><td>0,071239</td><td>-0,011349</td><td>-0,003901</td><td>0,009555</td></tr><tr><td>Journey</td><td>18,827602</td><td>0,000001</td><td>0,001712</td><td>0,000011</td><td>0,014267</td><td>0,000190</td><td>0,056793</td><td>0,000537</td><td>0,099894</td><td>0,014925</td><td>0,099897</td><td>5,176446</td><td>8,766384</td><td>0,053840</td><td>0,013196</td><td>0,252033</td><td>0,004883</td><td>0,004756</td><td>0,010789</td><td>0,009065</td><td>0,013321</td><td>0,016513</td><td>0,017425</td><td>0,011953</td><td>0,011949</td><td>0,009153</td><td>0,006695</td><td>0,009064</td><td>0,009774</td><td>0,008399</td><td>0,009690</td><td>0,010263</td><td>0,006205</td><td>0,013574</td><td>0,017236</td><td>0,020732</td><td>-0,047859</td><td>-0,033333</td><td>-0,025287</td></tr><tr><td>Gary Guthrie</td><td>15,748573</td><td>0,000001</td><td>0,002248</td><td>0,000002</td><td>0,004810</td><td>0,000110</td><td>0,013607</td><td>0,000337</td><td>0,061517</td><td>0,003782</td><td>0,061518</td><td>6,495517</td><td>9,460223</td><td>0,066562</td><td>0,026919</td><td>0,159486</td><td>0,002699</td><td>0,003052</td><td>0,003658</td><td>0,004291</td><td>0,003864</td><td>0,003002</td><td>0,002415</td><td>0,001980</td><td>0,001830</td><td>0,002035</td><td>0,002047</td><td>0,001372</td><td>0,000970</td><td>0,001493</td><td>0,001583</td><td>0,001526</td><td>0,002156</td><td>0,005674</td><td>0,015178</td><td>0,035134</td><td>-0,029680</td><td>-0,032482</td><td>-0,035547</td></tr><tr><td>Vampires Everywhere!</td><td>15,825088</td><td>0,000000</td><td>0,000248</td><td>0,000005</td><td>0,015662</td><td>0,000083</td><td>0,075073</td><td>0,000115</td><td>0,107669</td><td>0,016325</td><td>0,107671</td><td>-3,007912</td><td>-2,989236</td><td>0,035599</td><td>0,000000</td><td>0,344511</td><td>0,003613</td><td>0,004269</td><td>0,006089</td><td>0,004672</td><td>0,006969</td><td>0,005550</td><td>0,007147</td><td>0,007633</td><td>0,005224</td><td>0,006760</td><td>0,006611</td><td>0,006177</td><td>0,011249</td><td>0,009870</td><td>0,006935</td><td>0,010960</td><td>0,014116</td><td>0,015877</td><td>0,019195</td><td>0,012605</td><td>0,002612</td><td>0,057205</td><td>-0,010225</td></tr><tr><td>Michael Bublé</td><td>15,836534</td><td>0,000000</td><td>0,001402</td><td>0,000002</td><td>0,005525</td><td>0,000013</td><td>0,018443</td><td>0,000121</td><td>0,038257</td><td>0,005696</td><td>0,038259</td><td>-0,861922</td><td>-4,062485</td><td>0,060022</td><td>0,013814</td><td>0,254896</td><td>0,016396</td><td>0,013279</td><td>0,009805</td><td>0,008447</td><td>0,009472</td><td>0,011224</td><td>0,008724</td><td>0,006828</td><td>0,009279</td><td>0,008562</td><td>0,010823</td><td>0,009415</td><td>0,013456</td><td>0,012668</td><td>0,011124</td><td>0,020232</td><td>0,013192</td><td>0,031795</td><td>0,066335</td><td>0,066762</td><td>0,079481</td><td>0,057869</td><td>0,019297</td></tr></table>"));

        HPDF_SaveToFile(pdf, this->m_path_to_params_file.string().c_str());
        HPDF_Free(pdf);
      }

      void ParamsSelResource::error_handler(HPDF_STATUS   error_no,
                                           HPDF_STATUS   detail_no,
                                           void         *user_data)
      {
        WApplication::instance()->log("error") << "HPDF_New error: " << error_no << " " << detail_no;
      }

    }
  }
}
