#ifndef MIR_SP_PARAMSELRESOURCE_H_
#define MIR_SP_PARAMSELRESOURCE_H_
/*
 * Copyright (c) 2011,
 * Technical University Of Gdansk,
 * Faculty of Electronics, Telecommunications and Informatics,
 * Multimedia Systems Department
 * and/or its affiliates. All rights reserved.
 */
#include <Wt/WApplication>
#include <Wt/WLogger>
#include <Wt/WObject>
#include <Wt/WStreamResource>
#include <Wt/Http/Request>
#include <Wt/Http/Response>
#include <hpdf.h>

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>

namespace SyNaT
{
  namespace MIR
  {
    namespace SP
    {
      using namespace Wt;

      class ParamsSelResource : public WStreamResource
      {
        public:
          ParamsSelResource(WObject *parent = 0)
            : WStreamResource(parent), m_path_to_params_file("")
          {
            this->setBufferSize(10 * 1024);
          }

          virtual ~ParamsSelResource()
          {
            if (!this->m_path_to_params_file.empty())
            {
              try
              {
                boost::filesystem::remove(this->m_path_to_params_file);
              }
              catch(std::exception &e)
              {
                WApplication::instance()->log("error") << e.what();
              }
            }
            this->beingDeleted();
          }

          virtual void handleRequest(const Wt::Http::Request& request,
                             Wt::Http::Response& response);

          static void error_handler(HPDF_STATUS   error_no, HPDF_STATUS   detail_no, void         *user_data);

        protected:
          boost::filesystem::path      m_path_to_params_file;

          void createPdfFile();
      };
    }
  }
}

#endif /* MIR_SP_PARAMSELRESOURCE_H_ */
