/**
 *\file containerSlider.cpp
 *\class containerSlider
 *
 * \brief different pushButtons which change the content of the file downloaded
 *
 *
 * We can add in this class all the widgets we want
 * \author  Arribe B.
 *
 * \version 0.1
 *
 * \date 2011/11/09
 *
 */

#include "containerSlider.h"

containerSlider::containerSlider()
{
    WSlider *sliderHorizontal = new WSlider(Horizontal);
    sliderHorizontal->setRange(0,100);
    sliderHorizontal->setValue(10);
    sliderHorizontal->setTickInterval(5);
    sliderHorizontal->setTickPosition(WSlider::TicksBothSides);

    WSlider *sliderVertical = new WSlider(Vertical);
    sliderVertical->setRange(0,100);
    sliderVertical->setValue(10);
    sliderVertical->setTickInterval(5);
    sliderVertical->setTickPosition(WSlider::TicksBothSides);

    WGridLayout *gridLayout = new WGridLayout(this);
    gridLayout->addWidget(sliderHorizontal,1,1);
    gridLayout->addWidget(sliderVertical,3,3);
}


containerSlider::~containerSlider(){

}
