/**
 *\file main.cpp
 *
 *
 * \brief Main structure of a Wt program
 *
 * \class WtApplication
 * \brief our application class
 * \author  Arribe B.
 *
 * \version 0.1
 *
 * \date 2011/11/09
 *
 *
 *
 *
 */


#include <Wt/WApplication>
#include "containerSlider.h"


// c++0x only, for std::bind
// #include <functional>

using namespace Wt;




 class WtApplication : public WApplication{

  public:
         WtApplication(const WEnvironment& env)
  : WApplication(env),m_dialog(new containerSlider)
         {
           // set the title of the application
           this->setTitle("tuto13");
           // add the main container
	   m_dialog->resize(500, 500);
           root()->addWidget(m_dialog);
         }
  private:
         containerSlider * const m_dialog;
     };

WApplication *createApplication(const WEnvironment& env)
{
  /*
   * You could read information from the environment to decide whether
   * the user has permission to start a new application
   */
  return new WtApplication(env);
}

int main(int argc, char **argv)
{
  /*
   * Your main method may set up some shared resources, but should then
   * start the server application (FastCGI or httpd) that starts listening
   * for requests, and handles all of the application life cycles.
   *
   * The last argument to WRun specifies the function that will instantiate
   * new application objects. That function is executed when a new user surfs
   * to the Wt application, and after the library has negotiated browser
   * support. The function should return a newly instantiated application
   * object.
   */
  return WRun(argc, argv, &createApplication);
}




