/**
 *\file containerSlider.cpp
 *\class containerSlider
 *
 * \brief different pushButtons which change the content of the file downloaded
 *
 *
 * We can add in this class all the widgets we want
 * \author  Arribe B.
 *
 * \version 0.1
 *
 * \date 2011/11/09
 *
 */

#include "containerSlider.h"

containerSlider::containerSlider()
{
    //create the first slider
    WSlider *sliderHorizontal = new WSlider(Horizontal);

    //we put the range of the slider
    sliderHorizontal->setRange(0,100);


    //the first value
    sliderHorizontal->setValue(10);

    //the interval between each tick
    sliderHorizontal->setTickInterval(5);

    //the position of the tick
    sliderHorizontal->setTickPosition(WSlider::TicksBothSides);

    //we resize the slider
    sliderHorizontal->resize(300, 50);


    //we create another slider, the most simply possible
    WSlider *sliderVertical = new WSlider(Vertical);


    // we add it to the container
   // this->addWidget(sliderHorizontal);
    //this->addWidget(sliderVertical);

    WGridLayout *gridLayout = new WGridLayout(this);
    // we add it to the container
    gridLayout->addWidget(sliderHorizontal,1,1);
    gridLayout->addWidget(sliderVertical,3,3);


}


containerSlider::~containerSlider(){

}
