#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WInPlaceEdit>
#include <Wt/WLength>
#include <Wt/WSuggestionPopup>
#include <Wt/WStandardItemModel>
#include <Wt/WLineEdit>
#include <Wt/WText>
#include <Wt/WString>

#include <boost/bind.hpp>

using namespace Wt;
using namespace boost;


class MyApplication: public WApplication {
public:
    MyApplication(const Wt::WEnvironment& env);
    void selected(int selected__, WInPlaceEdit *edit__, WSuggestionPopup *popup__);
    void unset_focus(WInPlaceEdit *edit__);
};

MyApplication::MyApplication(const Wt::WEnvironment& env)
    : Wt::WApplication(env)
{
    setTitle("Test");
    WInPlaceEdit *inPlaceEdit__ = new Wt::WInPlaceEdit("", root());
   inPlaceEdit__->setButtonsEnabled(false);
   inPlaceEdit__->setEmptyText("empty!");
   inPlaceEdit__->setHeight(WLength(21, WLength::Pixel));
   inPlaceEdit__->lineEdit()->setHeight(WLength(21, WLength::Pixel));
   inPlaceEdit__->textWidget()->setHeight(WLength(21, WLength::Pixel));

   Wt::WSuggestionPopup::Options contactOptions = { "<b>",         // highlightBeginTag
      "</b>",        // highlightEndTag
      '\0',           // listSeparator      (for multiple addresses)
      "",        // whitespace
      "", // wordSeparators     (within an address)
      ""           // appendReplacedText (prepare next email address)
      };

   Wt::WSuggestionPopup *popup__ = new Wt::WSuggestionPopup(contactOptions, root());

   WStandardItemModel *model = new WStandardItemModel();
   popup__->setModel(model);
   popup__->forEdit(
         inPlaceEdit__->lineEdit(),
         WSuggestionPopup::PopupTrigger::DropDownIcon
               | WSuggestionPopup::PopupTrigger::Editing);

   inPlaceEdit__->lineEdit()->focussed().connect(boost::bind(&WSuggestionPopup::showAt, popup__, inPlaceEdit__->lineEdit()));

//   popup__->addSuggestion(" ", ""); // 'works', but isn't shown, Selectable with the arrows by deselecting any other option, and by then pressing enter
   popup__->addSuggestion("&nbsp;", ""); // is escaped to &amp;nbsp;
//   popup__->addSuggestion("...", ""); // workaround!
   popup__->addSuggestion("suggestion1", "1"); // suggestion 1

   popup__->activated().connect(
         boost::bind(&MyApplication::selected, this, _1, inPlaceEdit__, popup__));

}

void MyApplication::selected(int selected__, WInPlaceEdit *edit__, WSuggestionPopup *popup__)
{
   std::cout << "\nselected\n";
//   if(selected__ == 0) // default
   {
      std::string new_data__ = (asString(popup__->model()->data(selected__, Wt::DisplayRole))).toUTF8();
      if(new_data__ == "&nbsp;") {
         new_data__ = "";
      }
      std::cout << "\nnew data: '" << new_data__ <<"'\n";
//      std::string new_data__ = "";
      unset_focus(edit__);
      edit__->textWidget()->setText(new_data__);
      edit__->lineEdit()->setText(new_data__);
      edit__->setText(new_data__);
//      unset_focus(edit__);
      std::cout << "\nempty values set\n";
   }
}

void MyApplication::unset_focus(WInPlaceEdit *edit__)
{
   edit__->lineEdit()->setFocus(false);
   edit__->lineEdit()->hide();
   edit__->textWidget()->show();//textWidget()->clicked();//lineEdit()->setFocus(true);
}

WApplication*    createApplication(const Wt::WEnvironment& env) 
{
    WApplication* app = new MyApplication(env);
    return app;
}

int main(int argc, char *argv[])
{
    return Wt::WRun(argc, argv, &createApplication);
}
