#include <Wt/WApplication.h>
#include <Wt/WBootstrap5Theme.h>
#include <Wt/WContainerWidget.h>
#include <Wt/WDialog.h>
#include <Wt/WPushButton.h>
#include <Wt/WText.h>

#include <memory>

class Application final : public Wt::WApplication {
public:
  explicit Application(const Wt::WEnvironment& env);
};

Application::Application(const Wt::WEnvironment &env)
  : Wt::WApplication(env)
{
  setTheme(std::make_shared<Wt::WBootstrap5Theme>());

  auto btn = root()->addNew<Wt::WPushButton>("Show dialog");
  btn->clicked().connect([this] {
    auto dialog = root()->addChild(std::make_unique<Wt::WDialog>("Test Dialog"));

    dialog->rejectWhenEscapePressed();

    dialog->setWidth(800);
    dialog->setResizable(true);

    dialog->contents()->addNew<Wt::WText>(
            "This is really long text. This is really long text. This is really long text. "
            "This is really long text. This is really long text. This is really long text. "
            "This is really long text. This is really long text. This is really long text. "
            "This is really long text. This is really long text. This is really long text. "
            "This is really long text."
    );

    auto cancelBt = dialog->footer()->addNew<Wt::WPushButton>("Cancel");
    cancelBt->clicked().connect([dialog] { dialog->reject(); });
    dialog->finished().connect([this, dialog] { root()->removeChild(dialog); });
    dialog->show();
  });
}

int main(int argc, char *argv[])
{
  return Wt::WRun(argc, argv, [](const Wt::WEnvironment& env) {
    return std::make_unique<Application>(env);
  });
}
