#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WEnvironment>
#include <Wt/WFont>
#include <Wt/WLength>
#include <Wt/WPaintedWidget>
#include <Wt/WPainter>
#include <Wt/WPaintDevice>
#include <Wt/WScrollArea>

#include <stdlib.h>

using namespace Wt;
using namespace std;

class MyPaintedWidget : public WPaintedWidget {
	public:
        MyPaintedWidget ( WContainerWidget* parent = 0 );
	protected:
		void paintEvent(WPaintDevice *paintDevice);
	private:
		int width;
		int height;
};

MyPaintedWidget::MyPaintedWidget ( WContainerWidget* parent ) :
	WPaintedWidget ( parent ),
	width(2000),
	height(1000) {

		resize( WLength( width ), WLength( height ) );
		update();
}

void MyPaintedWidget::paintEvent(WPaintDevice *paintDevice) {
	WPainter painter(paintDevice);
	WFont font( Wt::WFont::Monospace );
	font.setSize(Wt::WFont::Medium);
	painter.setFont( font );

	WString s = "ABCDEFGHIJKLMNPQRSTUVWXYZ0123456789";

	for (int i=0; i<80; i++) {
		for (int j=0; j<10; j++) {
			painter.drawText(j*250,i*10,200,10,AlignLeft,TextSingleLine, s);
		}
	}
}

class MyApplication : public WApplication {
	public:
		MyApplication(const WEnvironment& env) : WApplication(env) {
			MyPaintedWidget *pw = new MyPaintedWidget();
			WScrollArea *area = new WScrollArea();
			area->resize(WLength(500), WLength(200));
			area->setWidget( pw );
			root()->addWidget( area );
		}
};

WApplication *createApplication(const WEnvironment& env) {
	return new MyApplication(env);
}

int main(int argc, char **argv) {
	return WRun(argc, argv, &createApplication);
}


