#include <Wt/Chart/WCartesianChart.h>
#include <Wt/WApplication.h>
#include <Wt/WEnvironment.h>
#include <Wt/WStandardItemModel.h>
#include <Wt/WFitLayout.h>

using namespace Wt;

class TestApp : public WApplication {
public:
  TestApp(const WEnvironment& env);
};

TestApp::TestApp(const WEnvironment& env) : WApplication(env)
{
  setTitle("WPaintedWidget in WFitLayout JS error w/progressive boot");

  auto model = std::make_shared<WStandardItemModel>(200, 2);
  for (int r = 0; r < model->rowCount(); ++r)
    for (int c = 0; c < model->columnCount(); ++c)
      model->setData(model->index(r, c), r * ((c == 1) ? 1 : -1));

  auto fitLayout = root()->setLayout(std::make_unique<WFitLayout>());

  auto chart = fitLayout->addWidget(std::make_unique<Chart::WCartesianChart>());

  chart->setModel(model);
  chart->addSeries(std::make_unique<Chart::WDataSeries>(1));
}

int main(int argc, char **argv)
{
  WLayout::setDefaultImplementation(LayoutImplementation::JavaScript);
  return WRun(argc, argv, [](const WEnvironment& env) {return std::make_unique<TestApp>(env);});
}
