
#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WJavaScript>

using namespace Wt;

class App : public WApplication {
public:
    App(const WEnvironment& env):
    WApplication(env),
        slot(root()),
        signal(root(), "mysignal", /* collectSlotJavaScript */ true) {
        slot.setJavaScript("function(o, e) { alert(123); }");
        doJavaScript("setTimeout(function() { " +
                signal.createCall() + "}, 3000);");
    }

    JSlot slot;
    JSignal<> signal;
};

WApplication* createApplication(const WEnvironment& env) {
    return new App(env);
}

int main(int argc, char** argv) {
    return WRun(argc, argv, &createApplication);
}

