#include "WtProblem.h"

#include <Wt/WBootstrap5Theme.h>
#include <Wt/WCssTheme.h>
#include <Wt/WHBoxLayout.h>
#include <Wt/WLayout.h>
#include <Wt/WPushButton.h>
#include <Wt/WVBoxLayout.h>

#include <filesystem>



/////////////////////////////////////////////////////////////////////////////
// class Menu

Menu::Menu(const Wt::WString& sText)
{
	setText(sText);
}

void Menu::setText(const Wt::WString& sText)
{
	m_sText = sText;
	Wt::WMenuItem* pMenuItem = parentItem();
	if (pMenuItem)
	{
		pMenuItem->setText(m_sText);
	}
}



/////////////////////////////////////////////////////////////////////////////
// class MenuBar

MenuBar::MenuBar()
{
	addStyleClass("main-nav");
	setResponsive(true);

	// Create root menu.
	//
	std::unique_ptr<Wt::WMenu> upRootMenu = std::make_unique<Wt::WMenu>();
	m_pRootMenu = upRootMenu.get();
	m_pRootMenu->setInternalPathEnabled();
	m_pRootMenu->setInternalBasePath("/");
	addMenu(std::move(upRootMenu));
}

Wt::WMenuItem* MenuBar::addSubMenu(std::unique_ptr<Menu> upSubMenu)
{
	auto upMenuItem = std::make_unique<Wt::WMenuItem>(upSubMenu->getText());
	auto* pMenuItem = m_pRootMenu->addItem(std::move(upMenuItem));
	pMenuItem->setMenu(std::move(upSubMenu));
	return pMenuItem;
}



/////////////////////////////////////////////////////////////////////////////
// class MessageBox

MessageBox::MessageBox()
{
	auto* pContens = contents();

	auto upCheckBox = std::make_unique< Wt::WCheckBox>();
	auto* pCheckBox = pContens->addWidget(std::move(upCheckBox));


//!!!!!!!!!!!! this cause the problem !!!!!!!!!!!!
	pCheckBox->hide();

// Due the check box is hidden, it will not be rendered. So Jacascript execution
// has an error in following function.
//
//	function f7(event) {
//		var e = event || window.event
//			, o = this;
//		if (e.ctrlKey || e.metaKey || (Wt4_9_1.button(e) > 1))
//			return true;
//		else {
//			if (o.classList.contains('disabled')) {
//				Wt4_9_1.cancelEvent(e);
//				return;
//			}
//			Wt4_9_1.$('o8w23q9').layout.adjust();
//			Wt4_9_1.show('o8w23q9', 'flex');
//
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// The call Wt4_9_1.$('o8w23r5') retuns 'null', because the check box is hidden and and it was not rendered.
// While access j6.className, execution of Javascript obviously crash.
//
//!!		var j6 = Wt4_9_1.$('o8w23r5');
//!!		j6.className = 'form-check-input Wt-chkbox';
//
// Why are these two code lines rendered?
//
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
//			Wt4_9_1.$('o8w23qj').classList.add('active');
//			Wt4_9_1.$('o8w23qk').classList.add('active');
//			Wt._p_.setHash('/menu', false);
//			{
//				var f = function() {
//					Wt._p_.setHash('/menu', true);
//				};
//				f(o, e);
//			}
//			Wt4_9_1.cancelEvent(e, 0x2);
//			Wt._p_.update(o, 's1d', e, true);
//		}
//	}

}



/////////////////////////////////////////////////////////////////////////////
// class MainWindow

MainWindow::MainWindow()
{
	// Add vertical layout to main window.
	//
	auto upMainWindowLayout = std::make_unique<Wt::WVBoxLayout>();
	upMainWindowLayout->setContentsMargins(0, 0, 0, 0);
	auto* pMainWindowLayout = upMainWindowLayout.get();
	setLayout(std::move(upMainWindowLayout));

	// Create menu bar.
	//
	auto upMenuBar = std::make_unique<MenuBar>();
	m_pMenuBar = upMenuBar.get();

	// Add menus to menu bar.
	//
	auto upSubMenu = std::make_unique<Menu>(L"Menu");
	//upSubMenu->addItem(L"MenuItem");
	m_pMenuBar->addSubMenu(std::move(upSubMenu));

	// Add menu bar to main window.
	//
	pMainWindowLayout->addWidget(std::move(upMenuBar));

	// Add button to main window;
	auto upButtonLayout = std::make_unique<Wt::WHBoxLayout>();

	auto upButton = std::make_unique<Wt::WPushButton>();
	auto* pButton = upButtonLayout->addWidget(std::move(upButton));
	pButton->setText("Show MessageBox");
	pButton->clicked().connect(this, &MainWindow::onClick);

	upButtonLayout->addStretch(100);

	pMainWindowLayout->addLayout(std::move(upButtonLayout));
}

void MainWindow::onClick()
{
	ShowMessageBox();
}

void MainWindow::ShowMessageBox()
{
	// Show message box with hidden checkbox.
	//
	auto upDialog = std::make_unique<MessageBox>();
	upDialog->setWindowTitle("MessageBox with hidden check box");
	upDialog->setModal(true);
	upDialog->setClosable(true);
	upDialog->exec();
}



/////////////////////////////////////////////////////////////////////////////
// class LoginPage

LoginPage::LoginPage()
{
	// Create vertical layout as main window layout.
	//
	auto upMainWindowLayout = std::make_unique<Wt::WVBoxLayout>();
	upMainWindowLayout->setContentsMargins(0, 0, 0, 0);
	auto* pMainWindowLayout = upMainWindowLayout.get();
	setLayout(std::move(upMainWindowLayout));

	// Create horizontal button layout with button and stretch.
	//
	auto upButtonLayout = std::make_unique<Wt::WHBoxLayout>();

	auto upButton = std::make_unique<Wt::WPushButton>();
	auto* pButton = upButtonLayout->addWidget(std::move(upButton));
	pButton->setText("Logon");
	pButton->clicked().connect(this, &LoginPage::onClick);

	upButtonLayout->addStretch(100);

	// Add button layout to main window layout.
	//
	pMainWindowLayout->addLayout(std::move(upButtonLayout));
}

void LoginPage::onClick()
{
	Application::instance()->ShowMainWindow();
}



/////////////////////////////////////////////////////////////////////////////
// class Application

Application::Application(const Wt::WEnvironment& environment)
	: Wt::WApplication(environment)
{
	// Set theme.
	//
	auto spBootstrapTheme = std::make_shared<Wt::WBootstrap5Theme>();
	setTheme(spBootstrapTheme);

#if 1
	ShowLoginPage();
#else
	ShowMainWindow();
#endif
}

void Application::ShowLoginPage()
{
	root()->clear();
	auto upLoginPage = std::make_unique<LoginPage>();
	root()->addWidget(std::move(upLoginPage));
}

void Application::ShowMainWindow()
{
	root()->clear();
	auto upMainWindow = std::make_unique<MainWindow>();
	auto* pMainWindow = upMainWindow.get();
	root()->addWidget(std::move(upMainWindow));

#if 1
	// Show dialog with checkbox.
	//
	pMainWindow->ShowMessageBox();

//!!!!!!!!!!!! this cause the problem !!!!!!!!!!!!
#endif
}



/////////////////////////////////////////////////////////////////////////////
// main

std::unique_ptr<Wt::WApplication> createApplication(const Wt::WEnvironment& env)
{
	return std::make_unique<Application>(env);
}

int main(int argc, char** argv)
{
	return WRun(argc, argv, &createApplication);
}
