#pragma once

#include <Wt/WApplication.h>
#include <Wt/WCheckbox.h>
#include <Wt/WContainerWidget.h>
#include <Wt/WDialog.h>
#include <Wt/WEnvironment.h>
#include <Wt/WMenu.h>
#include <Wt/WNavigationBar.h>
#include <Wt/WPopupMenu.h>
#include <Wt/WString.h>

class Application;



/////////////////////////////////////////////////////////////////////////////
// class Menu

class Menu : public Wt::WMenu
{
public:
	Menu(const Wt::WString& sText);

	void setText(const Wt::WString& sText);
	Wt::WString getText() const { return m_sText; }

protected:
	Wt::WString		m_sText;
};



/////////////////////////////////////////////////////////////////////////////
// class MenuBar

class MenuBar : public Wt::WNavigationBar
{
public:
	MenuBar();

	Wt::WMenuItem* addSubMenu(std::unique_ptr<Menu> upSubMenu);

private:
	Wt::WMenu* m_pRootMenu = nullptr;
};



/////////////////////////////////////////////////////////////////////////////
// class MessageBox

class MessageBox : public Wt::WDialog
{
public:
	MessageBox();
};



/////////////////////////////////////////////////////////////////////////////
// class MainWindow

class MainWindow : public Wt::WContainerWidget
{
public:
	MainWindow();

	void onClick();
	void ShowMessageBox();

private:
	Wt::WContainerWidget* m_pMenuBarContainer = nullptr;
	MenuBar* m_pMenuBar = nullptr;
};



/////////////////////////////////////////////////////////////////////////////
// class LoginPage

class LoginPage : public Wt::WContainerWidget
{
public:
	LoginPage();

	void onClick();
};



/////////////////////////////////////////////////////////////////////////////
// class Application

class Application : public Wt::WApplication
{
public:
	static Application* instance()
	{
		return static_cast<Application*>(__super::instance());
	}

public:
	Application(const Wt::WEnvironment& environment);

	void ShowLoginPage();
	void ShowMainWindow();
};
