#include	<Wt/WApplication>
#include	<Wt/WLabel>
#include	<Wt/WBreak>
#include	<Wt/WContainerWidget>
#include	<Wt/WPopupMenu>
#include	<Wt/WPoint>

#include	<boost/test/unit_test.hpp>
#include	<boost/lexical_cast.hpp>

using namespace std;

namespace
{
    class TestToolTip
        : public Wt::WApplication
    {
    public:
        TestToolTip( const Wt::WEnvironment& env )
            : Wt::WApplication( env )
        {
            setCssTheme( "polished" );
            root()->setAttributeValue( "oncontextmenu", "event.cancelBubble = true; event.returnValue = false; return false;" );

            for( int i = 0; i < 20; ++i )
            {
                auto x = new Wt::WLabel( "hover to show tip", root() );
                x->setToolTip( GetTooltipText(), Wt::XHTMLText );
                x->mouseWentUp().connect( SLOT( this, TestToolTip::MouseWentUp ) );
                new Wt::WBreak( root() );
            }

        }
        void MouseWentUp( const Wt::WMouseEvent& e )
        {
            Wt::WPopupMenu* popup = new Wt::WPopupMenu;
            for( int i = 0; i < 20; ++i )
                popup->addItem( boost::lexical_cast< std::string >( i ) + " test" );
            popup->popup( e );
        }
        std::string GetTooltipText()
        {
            return
                "<b>Title of tooltip</b>"
                "<br/>"
                "<br/>"
                "Some text text text text text text text text text text text text text text text<br/>"
                "Some text text text text text text text text text text text text text text text<br/>"
                "Some text text text text text text text text text text text text text text text<br/>"
                "Some text text text text text text text text text text text text text text text<br/>"
                "Some text text text text text text text text text text text text text text text<br/>"
                "Some text text text text text text text text text text text text text text text<br/>"
                "Some text text text text text text text text text text text text text text text<br/>"
                "Some text text text text text text text text text text text text text text text<br/>"
                "Some text text text text text text text text text text text text text text text<br/>"
                ;
        }
    };
}
