#include <Wt/WApplication.h>
#include <Wt/WBootstrap5Theme.h>

#include <Wt/WContainerWidget.h>
#include <Wt/WPanel.h>
#include <Wt/WHBoxLayout.h>
#include <Wt/WVBoxLayout.h>
#include <Wt/WPushButton.h>
#include <Wt/WStackedWidget.h>
#include <Wt/WMenu.h>
#include <Wt/WText.h>


using namespace Wt;



std::unique_ptr<WPanel> createTestPanel()
{
    auto pagePanel = std::make_unique<WPanel>();

    auto panelContainer = pagePanel->setCentralWidget(std::make_unique<WContainerWidget>());
    auto pageLayout = panelContainer->setLayout(std::make_unique<WVBoxLayout>());

    pageLayout->addWidget(std::make_unique<WPushButton>("Test"));

    pagePanel->disable();       // The crash happens only when the panel is disabled

    return pagePanel;
}


// -----------------------------------------------------------------------------------
std::unique_ptr<WApplication> createHelloApplication(const WEnvironment &env)
{
    auto app = std::make_unique<WApplication>(env);

    auto theme = std::make_shared<WBootstrap5Theme>();
    app->setTheme(theme);

    auto container = app->root()->addNew<WContainerWidget>();

    auto contents = std::make_unique<Wt::WStackedWidget>();

    Wt::WMenu *menu = container->addNew<Wt::WMenu>(contents.get());
    menu->setStyleClass("nav nav-pills flex-column");
    menu->setWidth(150);

    // Add menu items using the default lazy loading policy.
    menu->addItem("Dummy Menu Item", std::make_unique<Wt::WText>("Dummy Test"));
    menu->addItem("This will crash", createTestPanel());

    container->addWidget(std::move(contents));

    return app;
}


// -----------------------------------------------------------------------------------
int main(int argc, char *argv[])
{
    return Wt::WRun(argc, argv, &createHelloApplication);
}
