/*
 * Copyright (C) 2008 Emweb bv, Herent, Belgium.
 *
 * See the LICENSE file for terms of use.
 */

#include <Wt/WApplication>
#include <Wt/WBreak>
#include <Wt/WContainerWidget>
#include <Wt/WDialog>
#include <Wt/WLineEdit>
#include <Wt/WPushButton>
#include <Wt/WText>

// c++0x only, for std::bind
// #include <functional>

using namespace Wt;

/*
 * A simple hello world application class which demonstrates how to react
 * to events, read input, and give feed-back.
 */
class HelloApplication : public WApplication
{
public:
  HelloApplication(const WEnvironment& env);

private:
  WDialog *dlg1_;
  WDialog *dlg2_;

  void openDlg1();
  void openDlg2();
  void closeDlg1();
  void closeDlg2();
};

/*
 * The env argument contains information about the new session, and
 * the initial request. It must be passed to the WApplication
 * constructor so it is typically also an argument for your custom
 * application constructor.
*/
HelloApplication::HelloApplication(const WEnvironment& env)
  : WApplication(env)
{
  setTitle("Hello world");                               // application title

  dlg1_ = new WDialog("myDlg1");
  WPushButton *closeBtn1 = new WPushButton("close me");
  closeBtn1->clicked().connect(this, &HelloApplication::closeDlg1);
  dlg1_->contents()->addWidget(closeBtn1);
  dlg2_ = NULL;
    
  WPushButton *button1 = new WPushButton("Open dlg1.", root());              // create a button
  WPushButton *button2 = new WPushButton("Open dlg2.", root());              // create a button

  root()->addWidget(new WBreak());                       // insert a line break

  /*
   * Connect signals with slots
   *
   * - simple Wt-way
   */
  button1->clicked().connect(this, &HelloApplication::openDlg1);
  button2->clicked().connect(this, &HelloApplication::openDlg2);


  /*
   * - using a c++0x lambda:
   */
  // button->clicked().connect(std::bind([=]() { 
  //       greeting_->setText("Hello there, " + nameEdit_->text());
  // }));
}

void HelloApplication::openDlg1()
{
  dlg1_->show();
}

void HelloApplication::openDlg2()
{
  delete dlg2_;
  dlg2_ = new WDialog("myDlg2");
  WPushButton *closeBtn2 = new WPushButton("close me");
  closeBtn2->clicked().connect(this, &HelloApplication::closeDlg2);
  dlg2_->contents()->addWidget(closeBtn2);
  dlg2_->show();
}

void HelloApplication::closeDlg1()
{
  dlg1_->hide();
}

void HelloApplication::closeDlg2()
{
  dlg2_->hide();
}

WApplication *createApplication(const WEnvironment& env)
{
  /*
   * You could read information from the environment to decide whether
   * the user has permission to start a new application
   */
  return new HelloApplication(env);
}

int main(int argc, char **argv)
{
  /*
   * Your main method may set up some shared resources, but should then
   * start the server application (FastCGI or httpd) that starts listening
   * for requests, and handles all of the application life cycles.
   *
   * The last argument to WRun specifies the function that will instantiate
   * new application objects. That function is executed when a new user surfs
   * to the Wt application, and after the library has negotiated browser
   * support. The function should return a newly instantiated application
   * object.
   */
  
  static const char STR_HTTP_ARG[] = "--http-address=";
  static const char STR_APPROOT_ARG[] = "--approot=/etc/opt/pixxel/webui/approot";
  static const char STR_DOCROOT_ARG[] = "--docroot=/etc/opt/pixxel/webui/docroot";
  static const char FMT_HTTP_PORT_ARG[] = "--http-port=%d";
  static const char STR_ACCESSLOG_ARG[] = "--accesslog=/var/opt/pixxel/log/webui_log.txt"; //@TODO, make using this file optional (http://vmivm4:8000/Archos/ticket/3238)
  static const char STR_THREADS_ARG[] = "--threads=1";

  // collect information required to start Wt server
  char httpArg[32];
  snprintf(httpArg, sizeof(httpArg), "%s%s", STR_HTTP_ARG, "0.0.0.0");
  const char* szProcName = "hello";

  /** @todo argc/argv style arguments vs These options are not specified in the wt_config.xml configuration file,
      but may be indicated on the command-line, or within a configuration file that is located at /etc/wt/wthttpd. */
  char STR_HTTP_PORT_ARG[32];
  snprintf(STR_HTTP_PORT_ARG, sizeof(STR_HTTP_PORT_ARG), FMT_HTTP_PORT_ARG, 80);
  const char* myArgv[]=
  {
    szProcName,
    STR_APPROOT_ARG,
    STR_DOCROOT_ARG,
    httpArg,
    STR_HTTP_PORT_ARG,
    STR_ACCESSLOG_ARG,
    STR_THREADS_ARG
  };
  int myArgc = sizeof(myArgv) / sizeof(char*);

  return WRun(myArgc, (char**)myArgv, &createApplication);
}

