#include "stdafx.h"

#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WText>
#include <Wt/WPainter>
#include <Wt/WPaintedWidget>
#include <Wt/WContainerWidget>
using namespace Wt;

#include <process.h>

class HtmlCanvas : public WPaintedWidget
{
private:
	int cnt;
	int x, y;
	
public:
	HtmlCanvas(WContainerWidget *parent = 0);
	void changeContent(int nx, int ny);

protected:
	virtual void paintEvent(WPaintDevice *paintDevice);
};

HtmlCanvas::HtmlCanvas(WContainerWidget *parent)
  : WPaintedWidget(parent)
{
	cnt = 0; x = 10; y = 10;
    resize(300, 400);
}

void HtmlCanvas::changeContent(int px, int py) {
	x = px;
	y = py;
}

void HtmlCanvas::paintEvent(WPaintDevice *paintDevice) {
	wchar_t buff[20];

	_swprintf(buff, _T("%d"), cnt);
	cnt++;
	WPainter painter(paintDevice);
	painter.drawRect(0.0, 0.0, 300, 400);
	painter.setBrush(WBrush(WColor(200, 200, 200)));
	painter.drawRect(x, y, 100, 30);
	painter.drawText(x+5, y+5, 100-10, 30-10, AlignCenter, WString(buff));	
}

class SimpleApplication : public WApplication {

public:
	HANDLE m_signalData;
	HtmlCanvas* m_htmlCanvas;

	SimpleApplication (const WEnvironment& env);
	void HtmlCanvasMouseUp(const Wt::WMouseEvent& e);
};

SimpleApplication::SimpleApplication (const WEnvironment& env)
  : WApplication(env) {

	enableUpdates(true);

	setTitle("SimpleWt");

	root()->addWidget(new WText("<h1>SimpleWt</h1>"));

	m_htmlCanvas = new HtmlCanvas(root());
	m_htmlCanvas->setPreferredMethod(WPaintedWidget::HtmlCanvas);
	m_htmlCanvas->setOffsets(WLength(0), WFlags<Side>(Top));
	m_htmlCanvas->setOffsets(WLength(0), WFlags<Side>(Left));

	m_htmlCanvas->mouseWentUp().connect(this, &SimpleApplication::HtmlCanvasMouseUp);
	m_signalData = CreateEvent(NULL, FALSE, FALSE, NULL);
}

void SimpleApplication::HtmlCanvasMouseUp(const Wt::WMouseEvent& e) {
	m_htmlCanvas->changeContent(e.widget().x, e.widget().y);
	SetEvent(m_signalData);
} 

static void StartThread(void* p) {
	SimpleApplication* simpleApplication = (SimpleApplication*)p;
	for(;;) {
		WaitForSingleObject(simpleApplication->m_signalData , INFINITE);

		WApplication* wAp = simpleApplication;
		Wt::WApplication::UpdateLock lock(wAp);
		if (lock) {
			WFlags<PaintFlag> fl(PaintUpdate);

			simpleApplication->m_htmlCanvas->update(fl);
			wAp->triggerUpdate();
		}
	}
}

WApplication* createWTApp(const WEnvironment& env) {
	SimpleApplication* simpleApplication = new SimpleApplication (env);
	_beginthread(StartThread, 0, (LPVOID)simpleApplication);
	return simpleApplication;
}


int APIENTRY _tWinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow) {
	char *argv[] = { "SimpleWt.exe", "--http-address=0.0.0.0", "--http-port=8080", "--deploy-path=/simpleWt", "--docroot=."};

	WRun(5, argv, &createWTApp);
}