#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WText>
#include <Wt/WPainter>
#include <Wt/WPaintedWidget>
#include <Wt/WContainerWidget>
using namespace Wt;

#include <stdio.h>
#include <boost/thread.hpp>

class HtmlCanvas : public WPaintedWidget
{
private:
	int cnt;
	int x, y;
	
public:
	HtmlCanvas(WContainerWidget *parent = 0);
	void changeContent(int nx, int ny);

protected:
	virtual void paintEvent(WPaintDevice *paintDevice);
};

HtmlCanvas::HtmlCanvas(WContainerWidget *parent)
  : WPaintedWidget(parent)
{
	cnt = 0; x = 10; y = 10;
    resize(300, 400);
}

void HtmlCanvas::changeContent(int px, int py) {
	x = px;
	y = py;
}

void HtmlCanvas::paintEvent(WPaintDevice *paintDevice) {
	char buff[20];

	sprintf(buff, "%d", cnt);
	cnt++;
	WPainter painter(paintDevice);
	painter.drawRect(0.0, 0.0, 300, 400);
	painter.setBrush(WBrush(WColor(200, 200, 200)));
	painter.drawRect(x, y, 100, 30);
	painter.drawText(x+5, y+5, 100-10, 30-10, AlignCenter, WString(buff));	
}

class SimpleApplication : public WApplication {

  ~SimpleApplication();

public:
  boost::mutex mutex_;
  boost::condition_variable push_;
  bool stopping_;

  HtmlCanvas* m_htmlCanvas;

  SimpleApplication (const WEnvironment& env);
  void HtmlCanvasMouseUp(const Wt::WMouseEvent& e);
};

SimpleApplication::SimpleApplication (const WEnvironment& env)
  : WApplication(env) {

  stopping_ = false;

	enableUpdates(true);

	setTitle("SimpleWt");

	root()->addWidget(new WText("<h1>SimpleWt</h1>"));

	m_htmlCanvas = new HtmlCanvas(root());
	m_htmlCanvas->setPreferredMethod(WPaintedWidget::HtmlCanvas);
	m_htmlCanvas->setOffsets(WLength(0), WFlags<Side>(Top));
	m_htmlCanvas->setOffsets(WLength(0), WFlags<Side>(Left));

	m_htmlCanvas->mouseWentUp().connect(this, &SimpleApplication::HtmlCanvasMouseUp);
}

SimpleApplication::~SimpleApplication()
{
  boost::mutex::scoped_lock l(mutex_);
  stopping_ = true;
  push_.notify_all();

  push_.wait(l);
}

void SimpleApplication::HtmlCanvasMouseUp(const Wt::WMouseEvent& e) {
  m_htmlCanvas->changeContent(e.widget().x, e.widget().y);

  push_.notify_all();	
} 

static void StartThread(SimpleApplication* simpleApplication) {
  for(;;) {
    boost::mutex::scoped_lock l(simpleApplication->mutex_);
    simpleApplication->push_.wait(l);

    if (simpleApplication->stopping_) {
      simpleApplication->push_.notify_all();
      return;
    } 

    WApplication* wAp = simpleApplication;
    Wt::WApplication::UpdateLock lock(wAp);
    if (lock) {
      WFlags<PaintFlag> fl(PaintUpdate);
      
      simpleApplication->m_htmlCanvas->update(fl);
      wAp->triggerUpdate();
    }
  }
}

WApplication* createWTApp(const WEnvironment& env) {
	SimpleApplication* simpleApplication = new SimpleApplication (env);
	boost::thread(boost::bind(StartThread, simpleApplication));
	return simpleApplication;
}


int main(int argc, char **argv)
{
  return WRun(argc, argv, createWTApp);
}
