
#include <Wt/WApplication.h>
#include <Wt/WContainerWidget.h>
#include <Wt/WPushButton.h>
#include <Wt/WServer.h>
#include <Wt/WTemplate.h>

class DemoApp : public Wt::WApplication
{
public:

	DemoApp(const Wt::WEnvironment& env)
		: Wt::WApplication{ env }
	{
		auto* btn = this->root()->addNew<Wt::WPushButton>("click me!");
		btn->clicked().connect([this]()
		{
			const char* text = R"(${<show>}<a href="#/target">link</a>${</show>})";
			auto* t = this->root()->addNew<Wt::WTemplate>(text);
			t->setInternalPathEncoding(true);
		});
	}
};

//!
//!
//!
int main(int argc, char** args)
{
	Wt::WServer server(argc, args);
	server.addEntryPoint(Wt::EntryPointType::Application, [](const Wt::WEnvironment& env) { return std::make_unique<DemoApp>(env); });
	if (server.start())
	{
		server.waitForShutdown();
		server.stop();
	}
}
