#include <Wt/WApplication.h>
#include <Wt/WBootstrap5Theme.h>

#include <Wt/WContainerWidget.h>
#include <Wt/WOverlayLoadingIndicator.h>
#include <Wt/WMenu.h>
#include <Wt/WText.h>
#include <Wt/WVBoxLayout.h>
#include <Wt/WHBoxLayout.h>
#include <Wt/WStackedWidget.h>

using namespace Wt;


// -----------------------------------------------------------------------------------
std::unique_ptr<WContainerWidget> createResizeableCont()
{
    auto rootContUp = std::make_unique<WContainerWidget>();
    rootContUp->setAttributeValue("style", "width: 100%; height: 100%;");

    auto itemsVLayout = rootContUp->setLayout(std::make_unique<WVBoxLayout>());
    itemsVLayout->setContentsMargins(10, 10, 10, 10);                               // This causes the error in combination ...

    auto hResizeLayout = itemsVLayout->addLayout(std::make_unique<WHBoxLayout>(), 1);
    hResizeLayout->setPreferredImplementation(LayoutImplementation::JavaScript);

    hResizeLayout->addWidget(std::make_unique<WText>("Left Resizable"));
    hResizeLayout->addWidget(std::make_unique<WText>("Right Resizable"), 1);

    hResizeLayout->setResizable(0, true, WLength(25, LengthUnit::Percentage));      // .. with this causes the error

    return rootContUp;
}


// -----------------------------------------------------------------------------------
std::unique_ptr<WApplication> createHelloApplication(const WEnvironment &env)
{
    auto app = std::make_unique<WApplication>(env);

    app->setLoadingIndicator(std::make_unique<WOverlayLoadingIndicator>());

    auto theme = std::make_shared<WBootstrap5Theme>();
    app->setTheme(theme);

    auto contents = std::make_unique<Wt::WStackedWidget>();

    Wt::WMenu *menu = app->root()->addNew<Wt::WMenu>(contents.get());
    menu->setStyleClass("nav nav-pills flex-column");
    menu->setWidth(150);

    menu->addItem("Dummy Menu Item 1", std::make_unique<Wt::WText>("Stacked widget contents 1"));
    menu->addItem("Dummy Menu Item 2", std::make_unique<Wt::WText>("Stacked widget contents 2"));
    menu->addItem("Click here to freeze", createResizeableCont());

    app->root()->addWidget(std::move(contents));

    return app;
}


// -----------------------------------------------------------------------------------
int main(int argc, char *argv[])
{
    return Wt::WRun(argc, argv, &createHelloApplication);
}
