
#include <Wt/WApplication.h>
#include <Wt/WServer.h>

class DemoApp : public Wt::WApplication
{
public:

	DemoApp(const Wt::WEnvironment& env)
		: Wt::WApplication{ env }
	{
		doJavaScript("console.log('this is executed twice');", false);
		require("js1.js");
		doJavaScript("console.log('this is executed twice, too');", false);
		require("js2.js");
		doJavaScript("console.log('this is not');", false);
	}
};

//!
//!
//!
int main(int argc, char** args)
{
	Wt::WServer server(argc, args);
	server.addEntryPoint(Wt::EntryPointType::Application, [](const Wt::WEnvironment& env) { return std::make_unique<DemoApp>(env); });
	if (server.start())
	{
		server.waitForShutdown();
		server.stop();
	}
}