
#include <iostream>
#include <memory>
#include <Wt/WApplication.h>
#include <Wt/WContainerWidget.h>
#include <Wt/WPushButton.h>
#include <Wt/WServer.h>
#include <Wt/Http/Client.h>

class DemoApp : public Wt::WApplication
{
public:

	DemoApp(const Wt::WEnvironment& env)
		: Wt::WApplication{ env }
	{
		auto* b = root()->addNew<Wt::WPushButton>("Click me!");
		b->clicked().connect([]()
		{
			auto client = std::make_shared<Wt::Http::Client>();
			client->done().connect([client](Wt::AsioWrapper::error_code ec, const Wt::Http::Message& response) mutable
			{
				std::cout << "client done with code: " << ec << "\n";
				client.reset();
			});
			client->setTimeout(std::chrono::seconds{ 10 });
			client->get("http://www.webtoolkit.eu/wt/blog/feed/");
		});
	}
};

//!
//!
//!
int main(int argc, char** args)
{
	Wt::WServer server(argc, args);
	server.addEntryPoint(Wt::EntryPointType::Application, [](const Wt::WEnvironment& env) { return std::make_unique<DemoApp>(env); });
	if (server.start())
	{
		server.waitForShutdown();
		server.stop();
	}
}