/*
 * Copyright (C) 2010 Emweb bvba, Heverlee, Belgium.
 *
 * See the LICENSE file for terms of use.
 */

#include <Wt/WApplication>
#include <Wt/WBreak>
#include <Wt/WContainerWidget>
#include <Wt/WImage>
#include <Wt/WPushButton>
#include <Wt/WTabWidget>
#include <Wt/WText>
#include <Wt/WTextArea>
#include <Wt/WServer>
#include <Wt/WMenu>

#include "readObj.h"
#include "PaintWidget.h"

using namespace Wt;

std::vector<double> data;

/*
 * A pretty basic WebGL demo application
 */
class WebGLDemo : public WApplication
{
public:
  WebGLDemo(const WEnvironment& env);

private:    
  void fileLoad();
  void changeGl();

  WContainerWidget *glContainer_;
  PaintWidget *paintWidget_;
  WContainerWidget *topToolBar;
  WContainerWidget *rightFrame;
  WContainerWidget *footerBar;
  WMenu *rightMenu;
};

WebGLDemo::WebGLDemo(const WEnvironment& env)
  : WApplication(env)
{
  setTitle("Studio Viewer using WtC++ - WebGL");

  useStyleSheet(WApplication::appRoot() + "studioWebApp.css");

  topToolBar = new WContainerWidget(root());
  topToolBar->setStyleClass("topToolBarStyle");

  root()->addWidget(new WBreak());

  paintWidget_ = 0;

  glContainer_ = new WContainerWidget(root());
  glContainer_->setStyleClass("glContainerStyle");
  //glContainer_->resize(500, 500);
  glContainer_->setInline(false);

  WPushButton *loadButton = new WPushButton("Load", topToolBar);
  //loadButton->setStyleClass("buttonStyle");
  loadButton->clicked().connect(this, &WebGLDemo::fileLoad);
  WPushButton *changeButton = new WPushButton("Change", topToolBar);
  //changeButton->setStyleClass("buttonStyle");
  changeButton->clicked().connect(this, &WebGLDemo::changeGl);

  paintWidget_ = new PaintWidget(glContainer_);
  paintWidget_->setStyleClass("glContainerStyle");
  //paintWidget_->resize(500, 500);
  paintWidget_->setAlternativeContent(new WImage("nowebgl.png"));

  rightFrame = new WContainerWidget(root());
  rightFrame->setStyleClass("rightFrameStyle");

  rightMenu = new WMenu(Wt::Vertical, rightFrame);
  rightMenu->setStyleClass("rightFrameStyle");
  rightMenu->addItem("Test item", 0);
}

void WebGLDemo::fileLoad()
{
  /*delete paintWidget_;
  paintWidget_ = new PaintWidget(glContainer_);
  paintWidget_->resize(500, 500);
  //paintWidget_->setShaders(vertexShaderText_->text().toUTF8(), fragmentShaderText_->text().toUTF8());
  paintWidget_->setAlternativeContent(new WImage("nowebgl.png"));*/
}

void WebGLDemo::changeGl()
{
  //fragmentShaderText_->setText(fragmentShaderSrc);
  //vertexShaderText_->setText(vertexShaderSrc);
  //updateShaders();
}

WApplication *createApplication(const WEnvironment& env)
{
  return new WebGLDemo(env);
}

int main(int argc, char **argv)
{
  try {
    WServer server(argv[0]);
    readObj(WApplication::appRoot() + "teapot.obj", data);

    server.setServerConfiguration(argc, argv, WTHTTP_CONFIGURATION);

    server.addEntryPoint(Wt::Application, createApplication);
    if (server.start()) {
      int sig = WServer::waitForShutdown();

      server.stop();
    }
  } catch (WServer::Exception& e) {
    std::cerr << e.what() << "\n";
    return 1;
  } catch (std::exception& e) {
    std::cerr << "exception: " << e.what() << "\n";
    return 1;
  }
}

