#ifndef _THEME_TOGGLE_BUTTON_H_
#define _THEME_TOGGLE_BUTTON_H_

#include <Wt/WPushButton.h>
#include <Wt/WPopupMenu.h>
#include <Wt/WMenuItem.h>

#include <Wt/WJavaScriptSlot.h>
#include <Wt/WJavaScript.h>

#include <Wt/WString.h>
#include <string>


namespace Bootstrap5
{
namespace Theme
{
    const std::string Auto = "auto";
    const std::string Light = "light";
    const std::string Dark = "dark";
};

class ThemeToggleButton : public Wt::WPushButton
{
public:
    ThemeToggleButton();
    ~ThemeToggleButton() = default;

    // for now this only notifies with manual Selection
    Wt::Signal<std::string>& themeChanged() { return s_themeChanged; }

private:
    void prepareContent();
    void setupConnections();

private:
    Wt::WPopupMenu *popMenu;

    Wt::JSlot themeSelect;
    Wt::JSignal<std::string> selected;

    Wt::Signal<std::string> s_themeChanged; 

};

} // end namespace Bootstrap5

#endif // _THEME_TOGGLE_BUTTON_H_