
#include <Wt/WApplication>
#include <Wt/WRandom>
#include <Wt/WTableView>
#include <Wt/WStringListModel>

using namespace Wt;

class App : public WApplication {
public:
    App(const WEnvironment& env):
        WApplication(env) {
        WTableView* view = new WTableView(root());
        WStringListModel* model = new WStringListModel();
        for (int i = 0; i < 1000; i++) {
            model->addString(WRandom::generateId());
        }
        view->resize(500, 500);
        view->setModel(model);
        view->scrollTo(model->index(900, 0));
    }
};

WApplication* createApp(const WEnvironment& env) {
    return new App(env);
}

int main(int argc, char** argv) {
    return WRun(argc, argv, &createApp);
}

