
#include <boost/bind.hpp>

#include <Wt/WServer>
#include <Wt/WRandom>
#include <Wt/WApplication>
#include <Wt/WTableView>
#include <Wt/WStringListModel>

using namespace Wt;

class App : public WApplication {
public:
    App(const WEnvironment& env):
        WApplication(env) {
        view_ = new WTableView(root());
        model_ = new WStringListModel();
        for (int i = 0; i < 1000; i++) {
            model_->addString(WRandom::generateId());
        }
        view_->setModel(model_);
        view_->resize(500, 500);
        WServer::instance()->post(sessionId(), boost::bind(&App::scroll, this));
        enableUpdates();
    }

private:
    WTableView* view_;
    WStringListModel* model_;

    void scroll() {
        view_->scrollTo(model_->index(900, 0));
        triggerUpdate();
    }
};

WApplication* createApp(const WEnvironment& env) {
    return new App(env);
}

int main(int argc, char** argv) {
    return WRun(argc, argv, &createApp);
}

