/*
 * Copyright (C) 2008 Emweb bvba
 *
 * See the LICENSE file for terms of use.
 */

#include <Wt/WApplication>
#include <Wt/WHBoxLayout>

#include <Wt/WDate>
#include "TabDemoWidget.h"

using namespace Wt;

WApplication *createGalleryApplication(const WEnvironment& env)
{
	WApplication* app = new WApplication(env);

	WHBoxLayout *layout = new WHBoxLayout(app->root());
	layout->setContentsMargins(0, 0, 0, 0);
	layout->addWidget(new TabDemoWidget());
	layout->addStretch(1);

	app->setTitle("Chart Demo");

	app->addMetaHeader("viewport", "width=700, height=1200");

	return app;
}

int main(int argc, char **argv)
{
	return WRun(argc, argv, &createGalleryApplication);
}
