/*
 * Copyright (C) 2008 Emweb bvba, Kessel-Lo, Belgium.
 *
 * See the LICENSE file for terms of use.
 */

#include "TabDemoWidget.h"

#include <Wt/WVBoxLayout>
#include <Wt/WContainerWidget>
#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WGridLayout>
#include <Wt/WLabel>
#include <Wt/WLineEdit>
#include <Wt/WTabWidget>
#include <Wt/WPushButton>
#include <Wt/WHBoxLayout>

using namespace Wt;
using namespace Wt::Chart;

TabDemoWidget::TabDemoWidget(Wt::WContainerWidget* parent) : WContainerWidget(parent)
{
	WVBoxLayout* vLayout = new WVBoxLayout();
	WGridLayout* grid = new WGridLayout();

	grid->addWidget(new WLabel("Name"), 0, 0);
	grid->addWidget(new WLineEdit(), 0, 1);

	grid->addWidget(new WLabel("Place"), 1, 0);
	grid->addWidget(new WLineEdit(), 1, 1);

	vLayout->addLayout(grid);


	WTabWidget* tabs = new WTabWidget();

	WContainerWidget* detail1 = new WContainerWidget();
	WGridLayout* grid1 = new WGridLayout();
	detail1->setLayout(grid1);
	tabs->addTab(detail1, "Detail 1");
	grid1->addWidget(new WLabel("Mass"),0 ,0);
	grid1->addWidget(new WLineEdit(),0, 1);
	grid1->addWidget(new WLabel("gm"),0, 2);

	grid1->addWidget(new WLabel("Volume"),1 ,0);
	grid1->addWidget(new WLineEdit(),1, 1);
	grid1->addWidget(new WPushButton("mm3"),1, 2);

	WContainerWidget* detail2 = new WContainerWidget();
	WHBoxLayout* hLayout1 = new WHBoxLayout();
	WHBoxLayout* hLayout2 = new WHBoxLayout();
	WVBoxLayout* vLayoutTab = new WVBoxLayout();
	detail2->setLayout(vLayoutTab);
	vLayoutTab->addLayout(hLayout1);
	vLayoutTab->addLayout(hLayout2);
	tabs->addTab(detail2, "Detail 2");
	hLayout1->addWidget(new WLabel("Elasticity"));
	hLayout1->addWidget(new WLineEdit());
	hLayout1->addWidget(new WLabel("Pa"));

	hLayout2->addWidget(new WLabel("Resistance"));
	hLayout2->addWidget(new WLineEdit());
	hLayout2->addWidget(new WPushButton("ohm"));

	vLayout->addWidget(tabs);

	vLayout->addStretch(1);

	setLayout(vLayout);
}

