#include <Wt/WApplication.h>
#include <Wt/WStandardItemModel.h>
#include <Wt/WText.h>
#include <Wt/WTableView.h>


using namespace Wt;

class TestApp : public WApplication {
public:
  TestApp(const WEnvironment& env);

private:
  void addTableView(int rows);

};

void TestApp::addTableView(int rows) {
  auto model = std::make_shared<WStandardItemModel>(rows, 2);
  for (int r = 0; r < model->rowCount(); ++r) {
    for (int c = 0; c < model->columnCount(); ++c) {
      model->setData(model->index(r, c), r + c);
    }
  }

  auto tv = root()->addNew<WTableView>();
  tv->resize(330, 200);
  tv->decorationStyle().setBackgroundColor(WColor("goldenrod"));
  tv->setModel(model);
}

TestApp::TestApp(const WEnvironment& env) : WApplication(env)
{
  setTitle("WTableView regression - unnecessary horizontal scrollbar");


  root()->addNew<WText>("A WTableView without a vertical scrollbar does not get a horizontal scrollbar");
  addTableView(5);
  root()->addNew<WText>("With a vertical scrollbar, there still shouldn't be a horizontal scrollbar");
  addTableView(10);
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, [](const WEnvironment& env) {return std::make_unique<TestApp>(env);});
}
