#include <Wt/WBootstrap3Theme.h>
#include <Wt/WDialog.h>
#include <Wt/WEnvironment.h>
#include <Wt/WPushButton.h>
#include <Wt/WServer.h>
#include <Wt/WVBoxLayout.h>

std::unique_ptr<Wt::WApplication> createApplication(const Wt::WEnvironment &env)
{
    auto app = std::make_unique<Wt::WApplication>(env);

    auto appTheme = std::make_shared<Wt::WBootstrap3Theme>();

    app->setTheme(appTheme);

    auto layout = app->root()->setLayout(std::make_unique<Wt::WVBoxLayout>());

    auto button = layout->addWidget(std::make_unique<Wt::WPushButton>("Show dialog"));

    button->clicked().connect([]() {
        std::string wtVersion = wApp->environment().libraryVersion();

        auto dialog = wApp->addChild(std::make_unique<Wt::WDialog>("Dialog compiled with Wt: " + wtVersion));

        Wt::WGridLayout *layout = dialog->contents()->setLayout(std::make_unique<Wt::WGridLayout>());

        layout->addWidget(std::make_unique<Wt::WText>("Text1"), 0, 0, Wt::AlignmentFlag::Right);
        layout->addWidget(std::make_unique<Wt::WText>("Text2"), 1, 0, Wt::AlignmentFlag::Right);
        layout->addWidget(std::make_unique<Wt::WText>("Text3"), 2, 0, Wt::AlignmentFlag::Right);
        layout->addWidget(std::make_unique<Wt::WText>("Text4"), 3, 0, Wt::AlignmentFlag::Right);

        layout->addWidget(std::make_unique<Wt::WText>("Value1"), 0, 1, Wt::AlignmentFlag::Left);
        layout->addWidget(std::make_unique<Wt::WText>("Value2"), 1, 1, Wt::AlignmentFlag::Left);
        layout->addWidget(std::make_unique<Wt::WText>("Value3"), 2, 1, Wt::AlignmentFlag::Left);
        layout->addWidget(std::make_unique<Wt::WText>("Value4"), 3, 1, Wt::AlignmentFlag::Left);

        Wt::WPushButton *ok = dialog->footer()->addNew<Wt::WPushButton>("Ok");
        ok->setDefault(true);
        dialog->rejectWhenEscapePressed();

        // Accept the dialog
        ok->clicked().connect([dialog] { dialog->accept(); });

        // Process the dialog result.
        dialog->finished().connect([dialog] { wApp->removeChild(dialog); });

        dialog->show();
    });

    return app;
}

int main(int argc, char **argv)
{
    try
    {
        Wt::WServer server(argc, argv, WTHTTP_CONFIGURATION);

        server.addEntryPoint(Wt::EntryPointType::Application, std::bind(createApplication, std::placeholders::_1));

        server.run();
    }
    catch (Wt::WException &e)
    {
        std::cerr << "Exception: " << e.what() << std::endl;
    }
}
