#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WImage>
#include <Wt/WFileResource>
#include <Wt/WGridLayout>
#include <Wt/WText>
#include <Wt/WLineEdit>
#include <Wt/WVBoxLayout>
#include <Wt/WDatePicker>
#include <Wt/WPushButton>

using namespace Wt;

class TestDatePicker : public WApplication
{
    public:
        TestDatePicker(const Wt::WEnvironment& env);
};

TestDatePicker::TestDatePicker(const Wt::WEnvironment& env)
    : Wt::WApplication(env)
{
	WVBoxLayout *v = new WVBoxLayout(root());

	WContainerWidget *c = new WContainerWidget();
	WVBoxLayout *cv = new WVBoxLayout(c);
	WGridLayout *g = new WGridLayout();
	g->addWidget(new WText("Text1"), 0, 0, AlignLeft | AlignTop);
	WImage *i = new WImage(new WFileResource("image/png", "At.png"));
	i->setToolTip("Text1");
	g->addWidget(i, 0, 1, AlignLeft | AlignTop);
	g->addWidget(new WLineEdit(), 0, 2, AlignLeft | AlignTop);

	g->addWidget(new WText("Text2"), 1, 0, AlignLeft | AlignTop);
	i = new WImage(new WFileResource("image/png", "At.png"));
	i->setToolTip("Text2");
	g->addWidget(i, 1, 1, AlignLeft | AlignTop);
	g->addWidget(new WLineEdit(), 1, 2, AlignLeft | AlignTop);

	g->addWidget(new WText("Text3"), 2, 0, AlignLeft | AlignTop);
	i = new WImage(new WFileResource("image/png", "At.png"));
	i->setToolTip("Text3");
	g->addWidget(i, 2, 1, AlignLeft | AlignTop);
	g->addWidget(new WDatePicker(), 2, 2, AlignLeft | AlignTop);

	g->addWidget(new WPushButton("Button1"), 3, 0);
	g->addWidget(new WPushButton("Button2"), 3, 1);

	cv->addLayout(g, 0, AlignLeft | AlignTop);

	v->addWidget(c, -1, AlignCenter | AlignMiddle);
}

WApplication* createApplication(const Wt::WEnvironment& env) 
{
    return new TestDatePicker(env);
}

int main(int argc, char *argv[])
{
   return Wt::WRun(argc, argv, &createApplication);
}

