
#include <Wt/WServer>
#include <Wt/WApplication>
#include <Wt/WMemoryResource>
#include <Wt/WText>

using namespace Wt;

class MyApp : public WApplication {
public:
    MyApp(const WEnvironment& env):
        WApplication(env) {
        // comment following line to "fix" the bug
        require("https://ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js");
        bindWidget(new Wt::WText("Bug 1429 fixed!"), "bug1429");
    }
};

WApplication* createApplication(const WEnvironment& env) {
    return new MyApp(env);
}

int main(int argc, char** argv) {
    WServer server;
    server.setServerConfiguration(argc, argv);
    server.addEntryPoint(WidgetSet, &createApplication, "/text.js");
    std::string main_page =
        "<html><head></head><body>"
        "<div id='bug1429'></div>"
        "<script src='/text.js' type='text/javascript'></script>"
        "</body></html>";
    WMemoryResource main_res;
    main_res.setData(reinterpret_cast<const unsigned char*>(main_page.c_str()),
                     main_page.size());
    server.addResource(&main_res, "/");
    if (server.start()) {
        Wt::WServer::waitForShutdown();
        server.stop();
    }
}

