#include <Wt/WApplication.h>
#include <Wt/WBootstrap5Theme.h>

#include <Wt/WContainerWidget.h>
#include <Wt/WOverlayLoadingIndicator.h>
#include <Wt/WMenu.h>
#include <Wt/WText.h>
#include <Wt/WVBoxLayout.h>
#include <Wt/WHBoxLayout.h>
#include <Wt/WStackedWidget.h>
#include <Wt/WPanel.h>
#include <Wt/WTreeView.h>

using namespace Wt;


// -----------------------------------------------------------------------------------
std::unique_ptr<WContainerWidget> createResizeableCont()
{
    auto rootContUp = std::make_unique<WContainerWidget>();
    rootContUp->setAttributeValue("style", "width: 100%; height: 100%;");

    auto itemsVLayout = rootContUp->setLayout(std::make_unique<WVBoxLayout>());
    itemsVLayout->setContentsMargins(10, 10, 10, 10);

    auto flexLayout = itemsVLayout->addLayout(std::make_unique<WHBoxLayout>(), 1);
    flexLayout->setPreferredImplementation(LayoutImplementation::JavaScript);     // Crash in both modes: Flex and JavaScript

    flexLayout->addWidget(std::make_unique<WText>("Left Resizable"));
    flexLayout->addWidget(std::make_unique<WText>("Right Resizable"), 1);

    flexLayout->setResizable(0, true, WLength(25, LengthUnit::Percentage));  // Crash

    return rootContUp;
}


// -----------------------------------------------------------------------------------
std::unique_ptr<WPanel> createEndlessTreeViewPanel()
{
    auto localPanel = std::make_unique<WPanel>();

    auto panelCont = localPanel->setCentralWidget(std::make_unique<WContainerWidget>());
    auto vLayout = panelCont->setLayout(std::make_unique<WVBoxLayout>());
    auto hLayout = vLayout->addLayout(std::make_unique<WHBoxLayout>(), 1);

    hLayout->addWidget(std::make_unique<WTreeView>(), 1);   // The horizontal size will grow endless
    hLayout->addWidget(std::make_unique<WText>("Right"));

    return localPanel;
}


// -----------------------------------------------------------------------------------
std::unique_ptr<WApplication> createHelloApplication(const WEnvironment &env)
{
    auto app = std::make_unique<WApplication>(env);

    auto theme = std::make_shared<WBootstrap5Theme>();
    app->setTheme(theme);

    auto contents = std::make_unique<Wt::WStackedWidget>();

    Wt::WMenu *menu = app->root()->addNew<Wt::WMenu>(contents.get());
    menu->setStyleClass("nav nav-pills flex-column");
    menu->setWidth(150);

    menu->addItem("Dummy Menu Item", std::make_unique<Wt::WText>("Select one of the problematic widgets"));
    menu->addItem("Click (repeatedly) here to crash", createResizeableCont());
    menu->addItem("Click here to trigger endless horizontal WTreeView width", createEndlessTreeViewPanel());

    app->root()->addWidget(std::move(contents));

    return app;
}


// -----------------------------------------------------------------------------------
int main(int argc, char *argv[])
{
    return Wt::WRun(argc, argv, &createHelloApplication);
}
