#include <Wt/WApplication>
#include <Wt/WLabel>
#include <Wt/WPushButton>
#include <Wt/WContainerWidget>
#include <Wt/WTableView>
#include <Wt/WAbstractTableModel>
#include <iostream>

using namespace Wt;

class VirtualTable : public WAbstractTableModel
{
public:
  VirtualTable(WObject *parent)
    : colCount_(0),
      rowCount_(0)
  { }
     
  virtual int columnCount(const WModelIndex& parent = WModelIndex()) const
  {
    if (!parent.isValid())
      return colCount_;
    else
      return 0;
  }

  virtual int rowCount(const WModelIndex& parent = WModelIndex()) const
  {
    if (!parent.isValid())
      return rowCount_;
    else
      return 0;
  }

  virtual bool insertColumns(int column, int count,
			     const WModelIndex& parent = WModelIndex())
  {
    beginInsertColumns(parent, column, column + count - 1);
    colCount_ += count;
    endInsertColumns();

    return true;
  }

  virtual bool insertRows(int row, int count,
			  const WModelIndex& parent = WModelIndex())
  {
    beginInsertRows(parent, row, row + count - 1);
    rowCount_ += count;
    endInsertRows();

    return true;
  }

  virtual boost::any headerData(const WModelIndex& index,
				int role = DisplayRole) const
  {
    if (role == DisplayRole) {
      return boost::any(std::string("Header"));
    } else {
      return boost::any();
    }
  }

  virtual boost::any data(const WModelIndex& index,
			  int role = DisplayRole) const
  {
    if (role == DisplayRole) {
      return boost::any(std::string("Data"));
    } else {
      return boost::any();
    }
  }

private:
  int colCount_;
  int rowCount_;
};

class Test : public WApplication
{
public:
  Test(const WEnvironment& env) 
   : WApplication(env)
  {
    model_ = new VirtualTable(this);

    model_->insertColumns(0, 5);

    WTableView *w = new WTableView(root());
    w->setHeight(200);
    w->setModel(model_);

    WPushButton *b = new WPushButton("Add rows", root());
    b->clicked().connect(this, &Test::addRows);
  }

  void addRows() {
    model_->insertRows(model_->rowCount(), 7185);
  }

private:
  VirtualTable *model_;
};

WApplication *createApplication(const WEnvironment& env){
  return new Test(env);
}

int main(int argc, char *argv[]){
  return WRun(argc, argv, createApplication);
}

