/*
 * ttMain.cpp
 *
 *  Created on: 11.12.2012
 *      Author: Stoycho Stefanov
 */

#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WContainerWidget>
#include <Wt/WText>
#include <Wt/WTemplate>
#include <Wt/WPushButton>
#include <Wt/WGroupBox>

#include <iostream>
#include <string>
#include <boost/bind.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/thread/thread.hpp>

using namespace Wt;
using namespace std;

class MyWidget: public Wt::WContainerWidget
{
public:
    MyWidget(WContainerWidget *parent = 0):
        WContainerWidget(parent),
        button_(0),
        message_(new WTemplate(this))
    {
        message_->setTemplateText("${<if-message>}${message}${</if-message>}");
        reloadButton();
    }

    void refresh(){
        cout << "MyWidget::refresh" << endl;
        reloadButton();
        WWebWidget::refresh();
    };
private:
    Wt::WPushButton*button_;
    Wt::WTemplate *message_;
    void reloadButton() {
        static size_t cnt = 0;
        this->removeWidget(message_);
        if (button_){
            this->removeWidget(button_);
            cout << "delete the button" << endl;
            delete button_;
        }
        button_ = new Wt::WPushButton("start ("+boost::lexical_cast<string>(++cnt) +")");
        button_->clicked().connect(this, &MyWidget::showMsg);
        cout << "add new button" << endl;
        this->addWidget(button_);
        this->addWidget(message_);
        message_->setCondition("if-message", false);
    }

    void showMsg(){
        message_->setCondition("if-message", true);
        message_->bindWidget("message", new WText("is now running"));
        WApplication::instance()->processEvents();
        boost::this_thread::sleep(boost::posix_time::seconds(1));
        message_->bindWidget("message", new WText("done!"));
    }
};

void printMsg(){
    cout << "refresh on click" << endl;
}
class MyApp : public WApplication
{
public:
    MyApp(const WEnvironment& env): WApplication(env) {
        WPushButton *btn = new WPushButton("refresh",this->root());
        btn->clicked().connect(this->root(), &WContainerWidget::refresh);
        btn->clicked().connect(boost::bind(&printMsg));
        new MyWidget(this->root());
    }
};


WApplication *createApplication(const WEnvironment& env) {
    return new MyApp(env);
}

int main(int argc, char** argv) {
    return WRun(argc, argv, &createApplication);
}
