/*
 * serverRestart.cpp
 *
 *  Created on: 18.02.2013
 *      Author: Stoycho Stefanov
 */


#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WText>
#include <Wt/WPushButton>
#include <Wt/WContainerWidget>
#include <Wt/WBreak>
#include <Wt/WServer>
#include <Wt/WLink>
#include <Wt/WAnchor>
#include <string>
#include <iostream>

#include <signal.h>
#include <boost/bind.hpp>
#include <boost/thread.hpp>

using namespace std;
using namespace Wt;

bool restart(false);
int mainPid;

void logout(){
    WContainerWidget *w = WApplication::instance()->root();
    w->clear();
    new WAnchor(WLink(WLink::Url,WApplication::instance()->environment().deploymentPath()),"start",w);
    if (WApplication::instance()->environment().javaScript() ) {
        WApplication::instance()->processEvents();
    }
    WApplication::instance()->quit();
}


void restartServer(){
//    logout();
    restart = true;
    kill(mainPid,SIGINT);
}



Wt::WApplication* createApp(const Wt::WEnvironment& env) {
    Wt::WApplication* app = new Wt::WApplication(env);
    new WText(app->sessionId(),app->root());
    new WBreak(app->root());
    WPushButton *btn = new WPushButton("restart",app->root());
    btn->clicked().connect(boost::bind(&restartServer));
    return app;
}

int main(int argc, char** argv) {
    cout << WT_VERSION_STR << endl;
    mainPid = getpid();
    try {
        Wt::WServer server;
        server.setServerConfiguration(argc, argv);
        server.addEntryPoint(Wt::Application, createApp, "/", "./favicon.ico");

        while ( true ) {
            if (not server.isRunning()){
                try {
                    cout << "try start the server" << endl;
                    server.start();
                }
                catch (Wt::WServer::Exception& e) {
                    cout << "WServer::Exception: " << e.what() << endl;
                }
                catch (std::exception &e)   {
                    cout << "exception: " << e.what() << endl;
                    break;
                }
            }
            Wt::WServer::waitForShutdown();
            cout << "Return from waitForShutdown" << endl;
            cout << "server.stop()" << endl;
            server.stop();
            if (restart){
                restart = false;
                cout << "continue" << endl;
                continue;
            }
            else{
                break;
            }
        }
    }
    catch (Wt::WServer::Exception& e) {
        cout << "WServer::Exception: " << e.what() << endl;
    }
    catch (std::exception &e)   {
        cout << "exception: " << e.what() << endl;
    }
    return 0;
}

