/*
 * main.cpp
 *
 *  Created on: 13.03.2013
 *      Author: Stoycho Stefanov
 */

#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WPopupMenu>
#include <Wt/WMenu>
#include <Wt/WMenuItem>
#include <Wt/WText>
#include <Wt/WEvent>
#include <Wt/WGridLayout>
#include <Wt/WContainerWidget>
#include <Wt/WMessageBox>
#include <Wt/WPaintedWidget>
#include <Wt/WPainter>
#include <Wt/WVBoxLayout>
#include <boost/signal.hpp>
#include <boost/foreach.hpp>
#include <boost/bind.hpp>
//#include <Wt/W>
#include <Wt/WPushButton>
#include <iostream>
using namespace Wt;
using namespace std;


class PaintedFace: public WPaintedWidget {
public:
    PaintedFace(WContainerWidget *parent = 0)
    :
        WPaintedWidget(parent)
    {
        resize(30,40); // provide a default size !!???
    }

    void paintEvent(Wt::WPaintDevice *paintDevice)
    {
        Wt::WPainter *painter = new Wt::WPainter(paintDevice);
        painter->drawEllipse(0,0,width().value(),height().value());
    };
};

class Widget : public WContainerWidget {
public:
    Widget(WContainerWidget *parent = 0){
        addWidget(new PaintedFace(this));
        setPositionScheme(Absolute);
    }
};

class Panel : public WContainerWidget {
public:
    Panel(WContainerWidget *parent = 0)
    :
        WContainerWidget(parent),
        popup_(0)
    {
        setAttributeValue("oncontextmenu","event.cancelBubble = true; event.returnValue = false; return false;");
        decorationStyle().backgroundColor().setName("red");
        mouseWentUp().connect(this, &Panel::onMouseUp);
        setPositionScheme(Relative);
    }
    boost::scoped_ptr<Wt::WPopupMenu> popup_;
    boost::signals::connection onPopupHide_;
    void onMouseUp(const Wt::WMouseEvent &e) {
        switch (e.button()) {
            case  WMouseEvent::RightButton :
                showPopup(e);
                break;
            default: break;
        }
    }
    void popupAction(const Wt::WMouseEvent& e) {
        if (popup_->result() == 0) {
            return; // any Item was selected
        }
        else if (popup_->result()->text() == WString("widget")) {
            Widget *widget = new Widget(this);
            widget->setOffsets(e.widget().x,Left);
            widget->setOffsets(e.widget().y,Top);
            this->addWidget(widget);
        }
    }

    void showPopup(const WMouseEvent &e) {

        if (!popup_) {
            popup_.reset(new WPopupMenu());
            popup_->setAttributeValue("oncontextmenu","event.cancelBubble = true; event.returnValue = false; return false;");
            popup_->addItem("widget");
        }

        if(popup_->isHidden()){
            popup_->popup(e);
            popup_->refresh();
            onPopupHide_.disconnect();
            // (re)connect in order to use the actual mouse event coordinates
            onPopupHide_ = popup_->aboutToHide().connect(boost::bind(&Panel::popupAction,this,e));
        }
        else {
            popup_->hide();
        }
    }
};

class MyApp : public WApplication {
    public:
        MyApp(const WEnvironment& env)
        :
            WApplication(env){
            WContainerWidget *w = root();
            w->decorationStyle().backgroundColor().setRgb(14,232,133,142);
            WVBoxLayout *layout = new WVBoxLayout();
            layout->addWidget(new Panel(),1);
            w->setLayout(layout);
    }
};

WApplication *createApplication(const WEnvironment& env) {
    WApplication *app = new MyApp(env);
    app->setTitle("WMenu");
    app->setCssTheme("polished");
    app->refresh();
    return app;
};

int main(int argc, char **argv) {
    cout << "Wt = " << WT_VERSION_STR <<endl;
    return WRun(argc, argv, &createApplication);
}

